#include "unzen.h"          // audio framework include file
#include "umb_adau1361a.h"     // audio codec contoler include file
#include "mbed.h"
#include "arm_math.h"
#define CODEC_I2C_ADDR 0x38
#define DELAY_TIME       (550)  /* delay time in ms */
#define DELAY_BUF_SIZE   (44100 * DELAY_TIME / 1000)/* ring buffer size */
#define FEEDBACK 0.5;           /* feedback control */
DigitalOut myled1(LED1);
DigitalIn User_b1(PC_13);
Serial uart(SERIAL_TX,SERIAL_RX);
float32_t delay_buf[DELAY_BUF_SIZE];
unsigned int delay_buf_idx = 0;
float32_t l_lc[]={0};
float32_t l_x[]={0};
float32_t l_in[]={0};
float32_t l_delay[]={0};
int flag = 1;
char uart_read_value = 0;
   // customer signal processing initialization call back.
void init_callback(
           unsigned int block_size     // block size [sample]
           )
{
       // place initialization code here
}
 
 
   // customer signal processing call back.
void process_callback(
           float rx_left_buffer[],     // array of the left input samples
           float rx_right_buffer[],    // array of the right input samples
           float tx_left_buffer[],     // place to write the left output samples
           float tx_right_buffer[],    // place to write the left output samples
           unsigned int block_size     // block size [sample]
           )
{
    
       
   if(flag == 1){  
       // Sample processing
       for ( int i=0; i<block_size; i++){
           /*Bypass Sound*/
           tx_left_buffer[i] = rx_left_buffer[i]; //copy from input to output
           tx_right_buffer[i] = rx_left_buffer[i];//for guitar volume
           
       }
    }   
    else if(flag == 0){
       for ( int i=0; i<block_size; i++){
            
            /*Echo Effect*/
            l_in[0] = rx_left_buffer[i]/2.0;//原音を保存
            l_delay[0] = delay_buf[delay_buf_idx]*FEEDBACK;//フィードバック量の調整(FEEDBACK < 1をまもらないと発振する)
            arm_add_f32( l_in, l_delay, l_x, 1 );//ディレイ音と原音を合成(l_xに計算結果が格納)
            delay_buf[delay_buf_idx] = l_x[0];//フィードバック
            delay_buf_idx = (int)(delay_buf_idx + 1)%DELAY_BUF_SIZE;//ring bufferの更新
            tx_left_buffer[i] = l_x[0]*2.0;      // copy from L to L
            tx_right_buffer[i] = l_x[0]*2.0;     // copy from L to R
       } 
   }
}
 
 
 
int main() 
{    
    // I2C is essential to talk with ADAU1361
   I2C i2c(D14, D15);
   
    
    // create an audio codec contoler
    //shimabara::UMB_ADAU1361A codec(shimabara::Fs_32, i2c, CODEC_I2C_ADDR ); // Default Fs is 48kHz
    shimabara::UMB_ADAU1361A codec(shimabara::Fs_441, i2c, CODEC_I2C_ADDR );
    //shimabara::UMB_ADAU1361A codec(shimabara::Fs_48, i2c, CODEC_I2C_ADDR );
    //shimabara::UMB_ADAU1361A codec(shimabara::Fs_96, i2c, CODEC_I2C_ADDR );
 
      // create an audio framework by singlton pattern
   unzen::Framework audio;
 
        // Set I3C clock to 100kHz
   i2c.frequency( 100000 );
 
 
       // Configure the optional block size of signal processing. By default, it is 1[Sample] 
    //audio.set_block_size(16);
 
   
       // Start the ADAU1361. Audio codec starts to generate the I2C signals 
   codec.start();
 
       // Start the audio framework on ARM processor.  
   audio.start( init_callback, process_callback);     // path the initializaiton and process call back to framework 
 
 
       // periodically changing gain for test
   while(1)     
   {
           codec.set_hp_output_gain( 3, 3);
           codec.set_line_output_gain( 3, 3 );
           if(User_b1 == 1){//スイッチ入力に対応
               if(flag == 1){flag = 0;myled1 =1;uart.printf("Effect On \r\n");}
               else if(flag == 0){flag = 1;myled1 =0;uart.printf("Effect Off \r\n");}
               while(User_b1 == 1){}
           }
           if(uart.readable()== 1){uart_read_value = uart.getc();//Uart Output
               if(uart_read_value == 'e'){flag = 1;myled1 =0;uart.printf("Effect Off \r\n");}
               if(uart_read_value == 'd'){flag = 0;myled1 =1;uart.printf("Effect On \r\n");}
               }
   }
}