
#ifndef _CIRCULAR_ARRAY_H_
#define _CIRCULAR_ARRAY_H_
#include <stdint.h>

class CircularArray
{
    private:
    unsigned int m_capacity;
    volatile unsigned int w;
    volatile unsigned int r;
    volatile bool m_full;
    volatile bool m_empty;
    volatile uint8_t * data;
    volatile uint8_t * readerBuffer;
    uint16_t sizeRB;
    volatile uint8_t * writerBuffer;
    uint16_t sizeWB;
    
    public:
        CircularArray(unsigned int capacity);
        ~CircularArray();    
        uint8_t * getWritePointer();
        uint8_t * getReadPointer(uint16_t num);
        void writeElements(unsigned int num);
        void readElements(unsigned int num);
        unsigned int fillCapacity();
        unsigned int freeSpace();
        unsigned int size();
        unsigned int readable();
        bool full();
        bool empty();
};

#endif