#include "CircularArray.h"
#include <string.h>

CircularArray::CircularArray(unsigned int capacity)
{
    data = new uint8_t[capacity];
    m_capacity=capacity;
    m_full=false;
    m_empty=true;
    w=0;
    r=0;
    sizeRB=0;
    sizeWB=0;
    readerBuffer=0;
    writerBuffer=0;
}
CircularArray::~CircularArray()
{
    delete[] data;
}  


void volatile_memcpy(volatile uint8_t * dest, volatile uint8_t * src, uint16_t num)
{
    for(int i =0; i<num;i++)
    {
        dest[i]=src[i];
    }
}

uint8_t * CircularArray::getWritePointer()
{
    return (uint8_t *)data+w;
}


uint8_t * CircularArray::getReadPointer(uint16_t num)
{
    if(num <=readable())
    {
        return (uint8_t *)data+r;
    }
    else
    {
        if(sizeRB<num)
        {
            if(readerBuffer!=0) delete[] readerBuffer;
            readerBuffer = new uint8_t[num];
        }
        volatile_memcpy(readerBuffer,(uint8_t *)(data+r),readable());
        volatile_memcpy(readerBuffer+readable(),data,num-readable());
        return (uint8_t *)readerBuffer;
    }
}


void CircularArray::writeElements(unsigned int num)
{
    w=(w+num)%m_capacity;
    m_full=r==w;
}
void CircularArray::readElements(unsigned int num)
{
    r=(r+num)%m_capacity;
    m_empty=r==w;
    
}
unsigned int CircularArray::fillCapacity()
{
    if(w>r || m_empty)
    {
        return m_capacity-w;
    }
    else
    {
        return r-w;
    }
}
unsigned int CircularArray::freeSpace()
{
    if(w>r || m_empty)
    {
        return fillCapacity()+r;
    }
    else
    {
        return fillCapacity();
    }
    
}
unsigned int CircularArray::readable()
{
    if(w<r || m_full)
    {
        return m_capacity-r;
    }
    else
    {
        return w-r;
    }
    
}
unsigned int CircularArray::size()
{
    if(w<r || m_full)
    {
        return readable()+w;
    }
    else
    {
        return readable();
    }
    
}
bool CircularArray::full()
{
    return m_full;
    
}
bool CircularArray::empty()
{
    return m_empty;
}