#include "mbed.h"
#include "rtos.h"
#include "train.h"
/*
///DEbug
Serial pc(USBTX, USBRX);
*/

Train::Train(PinName fwd, PinName rwd, PinName pwm) : _fwd(fwd), _rwd(rwd), _pwm (pwm)
{
    _fwd = 0;
    _rwd = 0;
    _pwm = 0;
    _state = 0; // state os stopped
    _current_speed =0 ; //start at 0 speed
}

int Train:: AccConvert (int _acc) // Set acceleration curve, _acc in seconds, max 4 seconds, min 1 second
{
    if (_acc > 4)
        _acc = 4;
    else if (_acc < 1)
        _acc =1;
    acc = (_acc*0.01)*1000000;
    return acc;
}

void Train::SetSpeed(int trainSpeed)//Go to set target speed. Speed will be updated to reach speed.
{
    NewTrainSpeed = trainSpeed;
}


void Train::Update() //Update cycle to update speed
{
    if(NewTrainSpeed != CurrentTrainSpeed) {

        if(NewTrainSpeed > CurrentTrainSpeed) {
            CurrentTrainSpeed++;
            _pwm =  CurrentTrainSpeed*0.01;

        } else  {
            CurrentTrainSpeed--;
            _pwm = CurrentTrainSpeed*0.01;
        }
    }
    _pwm = CurrentTrainSpeed*0.01;
}

void Train::UpdateDir()
{
    if (CurrentTrainSpeed<=0) {
        if (NewDirection != CurrentDirection) {
            if (NewDirection ==1) {
                _fwd=1;
                _rwd=0;
                CurrentDirection=NewDirection;
            } else if (NewDirection ==2) {
                _rwd=1;
                _fwd=0;
                CurrentDirection=NewDirection;
            } else {
                _rwd=0;
                _fwd=0;
                CurrentDirection=NewDirection;
            }
        } else {
            t_SetDir.detach();
        }
    }
}


void Train::Enable(int _acc) // start speed monitoring of train
{
    acc = AccConvert(_acc); // Set acceleration curve, _acc in seconds, max 4 seconds, min 1 second
    NewTrainSpeed = 0; // NewPosition is 0 when started
    CurrentTrainSpeed = 0; //sets CurrentPosition to  0 when started
    t_SetSpeed.attach_us(this, &Train::Update, acc);            //starts servo Speed Ticker  speed of servo update pulse width steps in  us,    slow =100000 100ms per step
}

void Train::Disable()           //turns off Ticker Pulse
{
    t_SetSpeed.detach();
}

void Train::DirectStop()        // direct stop, can be used as emergency, if not reactivated
{
    NewTrainSpeed=0;
    //abrupt stop if still moving
    _fwd=0;
    _rwd=0;
    CurrentTrainSpeed=0;
    CurrentDirection=0;
}

void Train::SetDirection(int _dir)
{
    NewDirection = _dir;
    if (NewDirection != CurrentDirection) {
        NewTrainSpeed = 0;
        t_SetDir.attach(this, &Train::UpdateDir, 1); //check if direction can be changed (speed=0)
    }
}

int Train::GetDirection()
{
return CurrentDirection;
}

int Train::GetSpeed()
{
    return CurrentTrainSpeed;
}

