#include "square_app.h"

//Constructor. Calls the bass class (App) constructor and creact an AnalogOut object.//
SquareApp::SquareApp(Serial* serial) : App("Square wave", serial) {
    //Set analogOut attribute to a new AnalogOut object.//
    this->analogOut = new AnalogOut (PA_4);
    this->amplitude = 3.0f;                                                                      //Set the amplitude value.//
    this->frequence = 50.0f;                                                                      //Set the frequence value.//
}

void SquareApp::start()                                                                           //(Overriden) Method that runs when the app starts.//
{
    App::start();                                                                                 //Call bass class's start() method.//
    this->analogOut->write(this->amplitude/3.0f);                                                //Set the output to the amplitude.//
    this->timer.start();                                                                          //Start timer.//
    if ( this->amplitude > 3.0f ) {                                                              //Define the max amplitude value and check it.//
       this->analogOut->write(0);                                                                 //If >max value, output 0.//
    } else { this->analogOut->write(this->amplitude/3.0f);}                                      //If <max value, out the right expression.//

}

void SquareApp::run()                                                                             //(Overriden) Method that is called repeatedly when the app starts.//
{
   float p;                                                                                       //Define the float p.//
   p = (this->frequence*timer.read())-floor(this->frequence*timer.read());                        //p expression.//
   if ( p < 0.5f ) {                                                                              //Define the mini p value and check it.//
       this->analogOut->write(0);                                                                 //If < mini value, output 0.//
    } else { this->analogOut->write(this->amplitude/3.0f);}                                      //Set the output to the sin expression.//
    
    if ( this->frequence > 50.0f ) {                                                              //Define the max frequence value and check it.//
       this->analogOut->write(0);                                                                 //If >max value, output 0.//
    } 
}

void SquareApp::stop()                                                                            //(Overriden) Method that runs when the app stops.//
{
    App::stop();                                                                                  //Call bass class's stop() method.//
    this->analogOut->write(0.0f);                                                                 //Set output to 0V.//
    this->timer.stop();                                                                           //Stop the time and reset it.//
    this->timer.reset();
}
void SquareApp::setamplitude(float newamplitude)                                                  //(Overriden) Method that could set amplitude.//
{
    this->amplitude = newamplitude;                                                               //Set the new amplitude.//
}
void SquareApp::setfrequence(float newfrequence)                                                  //(Overriden) Method that could set frequence.//
{
    this->frequence = newfrequence;                                                               //Set the new frequence.//
}
