#include "constant_app.h"

//Constructor. Calls the bass class (App) constructor and creact an AnalogOut object.//
ConstantApp::ConstantApp(Serial* serial) : App("Constant Voltage", serial) {
    //Set analogOut attribute to a new AnalogOut object.//
    this->analogOut = new AnalogOut (PA_4);                                               //Set the amplitude value.//
    this->amplitude = 3.0f;                                                              //Set the frequence value.//
}

void ConstantApp::start()                                                                 //(Overriden) Method that runs when the app starts.//
{
    App::start();                                                                         //Call bass class's start() method.//
    this->analogOut->write(this->amplitude/3.0f);                                        //Set the output to the amplitude.//
    this->timer.start();                                                                  //Start timer.//
    if ( this->amplitude > 3.0f ) {                                                      //Define the max amplitude value and check it.//
       this->analogOut->write(0);                                                         //If >max value, output 0.//
    } else { this->analogOut->write(this->amplitude/3.0f);}                              //If <max value, out the right expression.//

}

void ConstantApp::run()                                                                   //(Overriden) Method that is called repeatedly when the app starts.//
{

}

void ConstantApp::stop()                                                                 //(Overriden) Method that runs when the app stops.//
{
    App::stop();                                                                         //Call bass class's stop() method.//
    this->analogOut->write(0);                                                           //Set output to 0V.//
    this->timer.stop();                                                                  //Stop the time and reset it.//
    this->timer.reset();
}

void ConstantApp::setamplitude(float newamplitude)                                       //(Overriden) Method that could set amplitude.//
{
    this->amplitude = newamplitude;                                                      //Set the new amplitude.//
}