#ifndef _APP_H_
#define _APP_H_

#include <string>
#include "mbed.h"

class App                                          //Abattract base class for all apps.//
{
    protected:
        string name;
        Serial* serialPort;
    public:
        App(string name, Serial* serialPort);      //Conatructor.//
        string getName();                          //Return the name of the app.//
        virtual void start();                      //Called when the app starts. Can be overriden by subclasses.//
        virtual void run() = 0;                    //Called repeatedly when app runas. Must be overriden by subclass.//
        virtual void stop();                       //Called when the app stops. Can be overriden by subclasses.//
};
#endif