#include "soft_pwm.h"


float SoftPwm::getPeriod()
{
      return this->period;
}

float SoftPwm::getDutyCycle()
{
    return this->dutyCycle;
}

void SoftPwm::setPeriod(float newPeriod)
{
    this->period = newPeriod;
}

void SoftPwm::setDutyCycle(float newDutyCycle)
{
    this->dutyCycle = newDutyCycle;
}
SoftPwm::SoftPwm(float initialPeriod, float initialDutyCycle)
{
    
     this->period = initialPeriod;
     this->dutyCycle = initialDutyCycle;
     
   
     this->timer.start();
}
bool SoftPwm::isOn()
{
    float onPhaseDuration = this->dutyCycle * this->period;
    float currentTime = this->timer.read();
    if (currentTime > this->period){
        this->timer.reset();
    }
    if (currentTime < onPhaseDuration){
        return true;
    }else {
        return false;
    }
}
