#include "sine_app.h"
 
 //Constructor. Calls the bass class (App) constructor and creact an AnalogOut object.//
SineApp::SineApp(Serial* serial) : App("Sine wave", serial) {
    //Set analogOut attribute to a new AnalogOut object.//
    this->analogOut = new AnalogOut (PA_4);
    this->amplitude = 3.0f;                                                          //Set the amplitude value.//
    this->frequence = 50.0f;                                                          //Set the frequence value.//
}

void SineApp::start()                                                                 //(Overriden) Method that runs when the app starts.//
{               
    App::start();                                                                     //Call bass class's start() method.//
    this->analogOut->write(this->amplitude/3.0f);                                    //Set the output to the amplitude.//
    this->timer.start();                                                              //Start timer.//
    if ( this->amplitude > 3.0f ) {                                                  //Define the max amplitude value and check it.//
       this->analogOut->write(0);                                                     //If >max value, output 0.//
    } else { this->analogOut->write(this->amplitude/3.0f);}                          //If <max value, out the right expression.//

}

void SineApp::run()                                                                   //(Overriden) Method that is called repeatedly when the app starts.//
{
   this->analogOut->write(this->amplitude/3.0f*0.5f*(1.0f+sin(this->frequence*6.28f*timer.read())));  //Set the output to the sin expression.// 
   
   if ( this->frequence > 50.0f ) {                                                   //Define the max frequence value and check it.//
   this->analogOut->write(0);                                                         //If >max value, output 0.//
    } else { this->analogOut->write(this->amplitude/3.0f*0.5f*(1.0f+sin(this->frequence*6.28f*timer.read())));} //If <max value, out the right expression.//
   

}

void SineApp::stop()                                                                   //(Overriden) Method that runs when the app stops.//
{
    App::stop();                                                                       //Call bass class's stop() method.//
    this->analogOut->write(0.0f);                                                      //Set output to 0V.//
    this->timer.stop();                                                                //Stop the time and reset it.//
    this->timer.reset();
}
void SineApp::setamplitude(float newamplitude)                                        //(Overriden) Method that could set amplitude.//
{
    this->amplitude = newamplitude;                                                   //Set the new amplitude.//
}
void SineApp::setfrequence(float newfrequence)                                        //(Overriden) Method that could set frequence.//
{
    this->frequence = newfrequence;                                                   //Set the new frequence.//
}
