#include "sawtooth_app.h"

SawtoothApp::SawtoothApp(Serial* serial) : App("Sawtooth Voltage", serial) {
    this->analogOut = new AnalogOut (PA_4);
}

void SawtoothApp::start()
{
    App::start();
    this->analogOut->write(0);
    this->timer.start(); 

}

void SawtoothApp::run()
{
   this->analogOut->write(1000* this->timer.read());
   
   if (this->timer.read()>0.001f){
       this->timer.reset();}
}

void SawtoothApp::stop()
{
    App::stop();
    this->analogOut->write(0);
    this->timer.stop();
    this->timer.reset();
}