#include "app.h"
#include "mbed.h"

App::App(string name, Serial* serialPort)                                 //Set name and serialPort attributes.//
{
    this->name = name;
    this->serialPort = serialPort;
}

string App::getName()                                                    //Return value of name attribute.//
{
    return this->name;
}

void App::start()                                                        //Called when the app starts.Can be overriden by subclasses.//
{
    //Send a message (using the serialPort attribute) saying that the app has started. The message contains the app's name.//
    string startMessage = "Started App: " + this->name + ".\r\n";
    this->serialPort->puts(startMessage.c_str());
}

void App::stop()                                                         //Called when the app stops.Can be overriden by subclasses.// 
{
    //Send a message (using the serialPort attribute) saying that the app has stoped. The message contains the app's name.//
    string stopMessage = "Stopped App: " + this->name + ".\r\n";
    this->serialPort->puts(stopMessage.c_str());
}