#ifndef INTERNAL_TEMP_H
#define INTERNAL_TEMP_H

#include "platform.h"

#if DEVICE_ANALOGIN

#include "analogin_api.h"

void temp_init(analogin_t *obj);

static inline uint32_t temp_read(analogin_t *obj);

static inline uint32_t temp_read_u32(analogin_t *obj);

uint16_t temperature_read_u16(analogin_t *obj);

float temperature_read(analogin_t *obj);

class InternalTemperature {

public:
    InternalTemperature() {
        temp_init(&_adc);
    }

    float read() {
        return temperature_read(&_adc);
    }

    unsigned short read_u16() {
        return temperature_read_u16(&_adc);
    }

#ifdef MBED_OPERATORS
    operator float() {
        return read();
    }
#endif

protected:
    analogin_t _adc;
};


#endif

#endif
