#include "InternalTemperature.h"

void temp_init(analogin_t *obj) {
    obj->adc = (ADCName)16;

    // Enable ADC1 clock source.
    RCC->APB2ENR |= RCC_APB2ENR_ADC1EN;

    // Enable the ADC
    ADC1->CR2 |= ADC_CR2_ADON;
    
    // Enable internal temperature sensor.
    ADC->CCR |= ADC_CCR_TSVREFE;
    
    // Set longest sample time just to be safe.
    ADC1->SMPR1 |= 0x1c;
}

static inline uint32_t temp_read(analogin_t *obj) {
    // Select the appropriate channel
    ADC1->SQR3 = (int) obj->adc;

    // Start conversion
    ADC1->CR2 |= ADC_CR2_SWSTART;

    // Wait for conversion to finish
    while (!(ADC1->SR & ADC_SR_EOC));

    uint32_t data = ADC1->DR;
    return data; // 12 bit
}

static inline uint32_t temp_read_u32(analogin_t *obj) {
    uint32_t value;
    value = temp_read(obj);
    return value;
}

uint16_t temperature_read_u16(analogin_t *obj) {
    uint32_t value = temp_read_u32(obj);

    return (value << 4) | ((value >> 8) & 0x000F); // 12 bit
}

float temperature_read(analogin_t *obj) {
    uint32_t value = temp_read_u32(obj);
    float ret = value * (1.0f / (float)0xFFF) * 3.0f;
    ret = (ret - 0.76f) / 2.5f + 25.0f;

    return ret;
}