#include "mbed.h"
#include "torch_app.h"
#include "Led.h"
#include "button.h"
#include "sawtooth_app.h"
#include "thermometer_app.h"
#include <sstream>
#include <vector>

int main() {
       Serial serialPort(PA_2, PA_3);
       Led red("red");
       Button button("user");
       TorchApp torch(&serialPort, &red);
       SawtoothApp sawtooth(&serialPort);
       ThermometerApp thermometer(&serialPort);
       
       vector<App*> apps;
       apps.push_back(&torch);
       apps.push_back(&sawtooth);
       apps.push_back(&thermometer);
       
       while (1)
       {
           serialPort.puts("Please select an App:\r\n");
           for(int i = 0; i < apps.size(); i++)
           {
               ostringstream oss;
               oss << i << ": " << apps[i]->getName() << "\r\n";
               serialPort.puts(oss.str().c_str());
           }
           
           char buffer[128];
           buffer[0] = 0;
           serialPort.scanf("%127[^\r\n]", buffer);
           istringstream iss(buffer);
           
           int menuChoice = -1;
           iss >> menuChoice;
           
           if (menuChoice < 0 || menuChoice >= apps.size())
           {
               serialPort.puts("Command not recognised.\r\n");
               continue;
           }
           
           App* currentApp = apps[menuChoice];
           currentApp->start();
           
           while (button.isPressed() == false)
           {
           currentApp->run();
           }
           currentApp->stop();
        }
}