#include "mbed.h"//mbed library
#include "MSCFileSystem.h"//usb Library
#include "MMA7660.h"//accelerometer library
#include "CMPS03.h"//compass library
#include "GPS.h"//GPS library
#include "C12832_lcd.h" // LCD screen library
MSCFileSystem fs("usb"); // Mount flash drive under the name "usb"
C12832_LCD lcd;// Local name for the LCD
GPS gps(p13,p14);//pin for RX and TX of the gps
Serial pc(USBTX, USBRX);
MMA7660 MMA(p28, p27);// local name for the Accelerometer
DigitalIn fire(p12);//pin for down movement joystick
DigitalIn right(p16);//pin for right movement for joystick
DigitalIn left(p13);//pin for left movement for joystick
CMPS03 compass(p9, p10, CMPS03_DEFAULT_I2C_ADDRESS);//pin for compass
DigitalOut connectionLed(LED1); // debug LED
int lock = 0;
int lock2 = 0;
int lock3 = 0;
int lock4 = 0;
int choice = 0;
int counter = 0;
Timer writeTime;//timer
void run();

void start()//starts and stops the game
{
    
    int counter = 0;
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Press down to start game");
    lcd.locate(0,20);
    lcd.printf("Hold down to stop game");
    wait(1.5);
    while (counter == 0) {
        if(fire) {
            run();
            counter = 1;
        }
    }

}
void run()// main funtion to get data and write it to files
{
    lcd.cls();//clear LCD for next reading round
    while(1) {
        writeTime.reset();//resets timer
        writeTime.start();//starts timer
        FILE *longd = fopen( "/usb/long.txt", "a");//opens a file on the usb in append mode
        FILE *latd = fopen( "/usb/lat.txt","a");
        FILE *bear = fopen( "/usb/bearing.txt","a");
        FILE *xData = fopen( "/usb/xData.txt","a");
        FILE *yData = fopen( "/usb/yData.txt","a");
        FILE *zData = fopen( "/usb/zData.txt","a");
        FILE *timeFile = fopen( "/usb/test.txt","a");
        if(gps.sample()) {//checks if it can get a gps position
            lcd.locate(0,10);//initial LCD location
            lcd.printf("Long: %.4f ", gps.longitude);//print to LCD
            lcd.printf("Lat: %.4f", gps.latitude);//print to LCD
            fprintf(longd,"%f\n",gps.longitude);//prints gps lonitude to file
            fprintf(latd,"%f\n",gps.latitude);//prints gps latitude to file
            writeTime.stop();//stops timer
            fprintf(timeFile,"%f\t",writeTime.read());//write time to file
            fclose(timeFile);
        } else {
            lcd.cls();//clear LCD for next reading round
            lcd.locate(3,3);//initial LCD location for x component of acceleration
            lcd.printf("Oh Dear! No lock :(\n");
            fprintf(longd,"%c\n","Oh Dear! No Lock :(");
            lcd.cls();//clear LCD for next reading round
        }
        fclose(latd);//closes file
        fclose(longd);//closes file
        lcd.locate(0,20);//initial LCD location
        lcd.printf("Bearing is: %f\n", compass.readBearing() / 10.0);//print to LCD
        lcd.locate(0,0);//initial LCD location
        lcd.printf("X:%.2f\n",MMA.x());//print x to LCD at locate position
        lcd.locate(40,0);//move LCD location for y component
        lcd.printf("Y:%.2f\n",MMA.y());//print y to LCD to new locate position
        lcd.locate(80,0);//move LCD location for z component
        lcd.printf("Z:%.2f\n",MMA.z());//print z to LCD
        fprintf(bear,"%.4f\n",compass.readBearing() / 10.0);
        fclose(bear);//closes file
        fprintf(xData,"%f\n",MMA.x());//writes to file
        fclose(xData);//closes file
        fprintf(yData,"%f\n",MMA.y());
        fclose(yData);//closes file
        fprintf(zData,"%f\n",MMA.z());
        fclose(zData);//closes file
        if(fire) {
            start();
            counter = 0;
        }
    }
}
void pitchSetUp()//function to set up the pitch
{
    lcd.cls();
    FILE *set = fopen( "/usb/setup.txt","w");

    while (lock == 0) {
        lcd.locate(3,3);
        lcd.printf("Move to position 1\n");
        if(fire) {//if joystick is pressed down
            if(gps.sample()) {
                fprintf(set,"%.5f ",gps.longitude);
                fprintf(set,"%.5f\n",gps.latitude);
                wait (0.5);
                lock = 1;
            } else {
                lcd.cls();
                lcd.printf("No Lock Please try again\n");
                lcd.cls();//clear LCD for next reading round
                lock = 0;
            }
        }
    }
    while (lock2 == 0) {
        lcd.locate(3,3);
        lcd.printf("Move to position 2\n");
        if(fire) {
            if(gps.sample()) {
                fprintf(set,"%.5f ",gps.longitude);
                fprintf(set,"%.5f\n",gps.latitude);
                wait (0.5);
                lock2 = 1;
            } else {
                lcd.cls();
                lcd.printf("No Lock Please try again\n");
                lcd.cls();//clear LCD for next reading round
                lock2 = 0;
            }
        }
    }
    while (lock3 == 0) {
        lcd.locate(3,3);
        lcd.printf("Move to position 3\n");
        if(fire) {
            if(gps.sample()) {
                fprintf(set,"%.5f ",gps.longitude);
                fprintf(set,"%.5f\n",gps.latitude);
                wait (0.5);
                lock3 = 1;
            } else {
                lcd.cls();
                lcd.printf("No Lock Please try again\n");
                lcd.cls();//clear LCD for next reading round
                lock3 = 0;
            }
        }
    }
    while (lock4 == 0) {
        lcd.locate(3,3);
        lcd.printf("Move to position 4\n");
        if(fire) {
            if(gps.sample()) {
                fprintf(set,"%.5f ",gps.longitude);
                fprintf(set,"%.5f\n",gps.latitude);
                wait (0.5);
                lock4 = 1;
            } else {
                lcd.cls();
                lcd.printf("No Lock Please try again\n");
                lcd.cls();//clear LCD for next reading round
                lock4 = 0;
            }
        }
    }
    fclose(set);
    start();//runs the run fution

}
int main()//main funtion
{
    //give choice to what the user wants to do
    lcd.cls();
    while (choice == 0) {
        int choice2 =0;
        lcd.locate(3,3);
        lcd.printf("Pitch Set Up\n");
        if (fire) {//if joystick is pressed down
            pitchSetUp();//runs pitch setup funtion
            choice =1;
        }
        if(right) {//if joystick is pressed right
            lcd.cls();
            lcd.locate(3,3);
            lcd.printf("Run Game\n");
            //counter = counter++;
            wait(0.5);//wait for half a second

            while (choice2 == 0) {
                if (fire) {
                    start();//runs the run funtion
                    choice =1;
                    choice2 = 1;
                }
                if (left) {//if joystick is pressed to the left
                    choice2 = 1;
                    choice = 0;
                    main();//runs the main funtion
                }
            }
        }
    }
}