/*/least updates:
this program is based on exploration 7 which is PI controller on theta only.
##done steps:
-------------
1)avoiding obstacle.
2)switching modes must be in the navigation function.
3)case if Obs_opp=0.
4)line 413 if Robs=0 or Lobs=0 must be =1.5

##next steps to be done:
-----------------------
1)position of Xtow.
2)dot product check line 431&459.
3)exiting conditions check.
*///
/**
 * this algorithm is Exploration algo.
 */
#include "Motor.h"
#include "QEI.h"
#include"math.h"
#include "SpaceSensor.h"
#include "SHARPIR.h"


#define PPDFactor 0.7575757575757576/1.385714285714286 //pulse per Distance Factor
#define LPPD 84.5374/PPDFactor //Left Pulse Per Distance
#define RPPD 84.0804/PPDFactor //Left Pulse Per Distance

#define delta 55
#define rovID 2

#define acquizitiontimeinterrupt 0.2
#define navigationtimeinterrupt 0.6

#define StopOtherComm  's'
#define BeginComm  'b'
#define BroadcastAddress  '0'
#define Inatialize  'i'
#define ACK  'k'
#define Delimitier  'e'
#define ID  '2'
#define YouCanComm 'u'
#define mode 'm'
#define OnlineUpdate 'o'
#define GroupHeading 'g'

//functions identification
void read_string();
void motor_intialize();
void PWM_cal();
void Distance_calculation();
void Get_Window(int j,float *vec,float *vec2);
void Energy_cal(float *Energy,float *W,float Threshold1[3]);
void angle_cal(float *theta,float *theta_dot,float *E,float Threshold[3]);
void move(float Lperiod,float Rperiod);
void navigation_model();
void RotateLeft(float Lperiod,float Rperiod);
void RotateRight(float Lperiod,float Rperiod);
void Stop();
void rotation();
void errorfun();
void GTG_mode();
void FollowWall();
void First_FW();
void Wall_Following();
void min_Obs_opp();
void compass_mean(int j,float *vec);
void North_facing();
void elepsoidToCircle();
void reset_parameters();
//initialization fun
void Group_CenterInitialize();
void Go_to_relative_initialized_position();
//end initialization fun

DigitalOut myled(LED1);
Serial xbee(p9, p10); //Creates a variable for serial comunication through pin 28 and 27
SHARPIR IR_front(p20); //the output of the sharpIR sensor is connected to the MBEDs pin 10.
SHARPIR IR_right(p19); //the output of the sharpIR sensor is connected to the MBEDs pin 10.
SHARPIR IR_left(p18); //the output of the sharpIR sensor is connected to the MBEDs pin 10.

Motor leftFrontMotor(p21, p16, p15);  //pwm, inB, inA
Motor rightFrontMotor(p22, p12, p11); //pwm, inA, inB
Motor leftBackMotor(p23, p8, p7);  //pwm, inB, inA
Motor rightBackMotor(p24, p6, p5); //pwm, inA, inB

QEI leftBackQei(p25, p26, NC, 151);  //chanA, chanB, index, ppr
QEI rightBackQei(p29, p30, NC, 147); //chanB, chanA, index, ppr
//Tuning parameters calculated from step tests;
//see http://mbed.org/cookbook/PID for examples.
SpaceSensor SS(p13, p14);
//Left motor working variables.
int leftPulses     = 0;
int leftPrevPulses = 0;
float leftVelocity = 0.0;

//Right motor working variables.
int rightPulses     = 0;
int rightPrevPulses = 0;
float rightVelocity = 0.0;

//angle parameters.
float sfgyro=2;
float FIRtheta[3],FIR_W[3],FIR_E[3],sigmoid,error,errorI=0,LTP,RTP;
float FIR_Thresh[3]= {0.00145,0.000674,0.006452};
float EulerAngles[3];
float compass[3];

bool theta_update;
float LPWM,RPWM;
float dis=0,rightDis,leftDis;


//read string parameters
float X,Y,R,Theta_base_st,Fobstacles_dis,Lobstacles_dis,Robstacles_dis;
char Ar_st[30];
char X_coord[10];
char Y_coord[10];
char st[128];

//navigation model parameters
float prev_dis[3];
float post_dis[3];
float current_theta,rot_theta;

//Obasticle avoidance Parameters
float current_Obs_dis,Obs_h,gradient_Obs;
int Obs_factor;
bool FWM,GTGM,ccw,cw;
float Obs_adj,Obs_opp,Obs_hyp,Obs_dis,Obs_alpha_opp,Obs_alpha,FWtheta,Xtow;
float GTGtheta,dot_product_cond;
float h_Obsinv,error_inv;
//NORTH FACING PARAMETERS
bool northfacing=false;
//initializatioin parameters
bool initialization_state;
float DWR[3][2];
float PRC[3][2];
char SHAPE='L';

//time parameters
Timer t;
Ticker timer,timer2;

void get_theta()
{
    angle_cal(FIRtheta,FIR_W,FIR_E,FIR_Thresh);
    SS.ReadfilteredtaredEulerAngles(EulerAngles);
    if(northfacing) {
        compass_mean(15,compass);
        elepsoidToCircle();
    } else SS.Readcompass(compass);
    Fobstacles_dis=-1;//IR_front.cm();//low range will return -1.0& for far range will return 0.
    Lobstacles_dis=-1;//IR_left.cm();
    Robstacles_dis=-1;//IR_right.cm();

}
bool I_CanBeginComm=false;
bool NoOtherComm=true;
bool CanComm=true;
bool Group_Heading=false;
bool SendMode=false;
bool Intializzed=false;
int Periorty=0;
float X12=6,X23=7,X13=8,Y12=3,Y23=2,Y13=1;
float RoverDataX[3];//,X=5;
float RoverDataY[3];//Y=7;
void GetRoverData(char S[]);
void ParseRoverData(char S[],int i);
void ParseXYGH(float &X,float &Y,char S[],int i);
void FarmatXYGH(char S[]);
void TDM_Communication(char StringToSend[]);
void Communication();
void FormatCoordinates(char [],float X12,float X23,float X32,float Y12,float Y23,float Y32);
void GetCoordinates(char S[],float &X12,float &X23,float &X13,float &Y12,float &Y23,float& Y13,int i);
void put_value(char string[],int & length ,float Z);
int GetNum(char c);
float GetValue(char b,char e,char S[],int &i);

int main()
{
    motor_intialize();
    FWM=false;
    GTGM=true;
    ccw=false;
    cw=false;
    xbee.attach(&Communication,Serial::RxIrq);
    printf("Start of Running\n\r");
    while(1) {
    if (Intializzed){
    Group_CenterInitialize();
    X=0;
    Y=100;
    R=sqrt(X*X+Y*Y);
    Theta_base_st=atan2(X,Y);
    GTG_mode();
    Intializzed=false;
}
    }//big fat loop
    
}//main loop

void read_string()
{
    int i=0;
    char c;
    c=xbee.getc();
    if(c=='B') {
        while(1) {
            c=xbee.getc();
            if(c=='E')break;
            Ar_st[i]=c;
            i++;
            myled != myled;

        }

        int count=0,j=0;
        if(Ar_st[j]=='X') {
            while(1) {
                j++;
                if(Ar_st[j]=='Y')break;
                X_coord[count]=Ar_st[j];
                count++;
            }
            X=atof(X_coord);
            count=0;
        }
        if(Ar_st[j]=='Y') {
            while(1) {
                j++;
                Y_coord[count]=Ar_st[j];
                count++;
                if(j==i)break;
            }
            Y=atof(Y_coord);
            count=0;
        }
    }
    ////xbee.puts("complete");
    R=sqrt(X*X+Y*Y);
    Theta_base_st=atan2(X,Y);
    sprintf( st ,"Rover will move %f cm & %f cm \r\n",X,Y);
    //xbee.puts(st);
    sprintf( st ,"Rover will move %f cm & %f Degree\r\n",R,Theta_base_st);
    //xbee.puts(st);

}
void motor_intialize()
{
    leftFrontMotor.period(0.00005);  //Set motor PWM periods to 20KHz.
    rightFrontMotor.period(0.00005);
    leftBackMotor.period(0.00005);  //Set motor PWM periods to 20KHz.
    rightBackMotor.period(0.00005);
}

void errorfun()
{
    error=current_theta-FIRtheta[0];
    errorI=error+errorI;
    float h;
    h=6*error;//+0.01*errorI;
    sigmoid=4/(1+exp(h))-2;
    if(sigmoid<0) {
        RTP=1+sigmoid;
        LTP=1;
    } else if(sigmoid>0) {
        RTP=1;
        LTP=1-sigmoid;
    } else {
        RTP=1;
        LTP=1;
    }
}
void PWM_cal()
{
    errorfun();
    RPWM= 0.9*RTP;
    LPWM= 0.9*LTP;
}
void Distance_calculation()
{
    leftPulses  = leftBackQei.getPulses();
    rightPulses = rightBackQei.getPulses();
    leftDis  = (leftPulses)*2*3.14159*3/LPPD;
    rightDis = (rightPulses)*2*3.14159*3/RPPD;
    dis= (rightDis+leftDis)/2;
}
void Get_Window(int j,float *vec,float *vec2)
{
    float vector1[3]= {0,0,0};
    for(int i=0; i<3; i++) {
        vec[i]=0;
        vec2[i]=0;
    }
    int k=0;
    while(k<j) {
        SS.Readgyros(vector1);
        //SS.Readaccelerometer(vector2);
        for(int i=0; i<3; i++) {
            vec[i]=vector1[i]*vector1[i]+vec[i];
        }
        for(int i=0; i<3; i++) {
            vec2[i]=vector1[i]+vec2[i];
        }
        k++;
    }
    for(int i=0; i<3; i++) {
        vec[i]=vec[i]/(j);
    }
    for(int i=0; i<3; i++) {
        vec2[i]=vec2[i]/(j);
    }
}
void Energy_cal(float *Energy,float *W,float Threshold1[3])
{
    Get_Window(10,Energy,W);
    for(int i=0; i<3; i++) {
        if(Energy[i]<Threshold1[i]*sfgyro)W[i]=0;
    }
    for(int i=0; i<3; i++)W[i]=W[i];
}
void angle_cal(float *theta,float *theta_dot,float *E,float Threshold[3])
{
    Energy_cal(E,theta_dot,Threshold);
    theta[0]=theta_dot[0]*(0.2)+theta[0];
    theta[1]=theta_dot[1]*(0.2)+theta[1];
    theta[2]=theta_dot[2]*(0.2)+theta[2];
}
void move(float Lperiod,float Rperiod)
{
    leftFrontMotor.speed(Lperiod);
    leftBackMotor.speed(Lperiod);

    rightFrontMotor.speed(Rperiod);
    rightBackMotor.speed(Rperiod);
}
void Stop()
{
    leftFrontMotor.brake();
    rightFrontMotor.brake();
    leftBackMotor.brake();
    rightBackMotor.brake();
}

void RotateLeft(float Lperiod,float Rperiod)
{
    leftFrontMotor.speed(-Lperiod);
    leftBackMotor.speed(-Lperiod);

    rightFrontMotor.speed(Rperiod);
    rightBackMotor.speed(Rperiod);
}

void RotateRight(float Lperiod,float Rperiod)
{
    leftFrontMotor.speed(Lperiod);
    leftBackMotor.speed(Lperiod);

    rightFrontMotor.speed(-Rperiod);
    rightBackMotor.speed(-Rperiod);
}
//////////////////////////////////////////////////////////////////////////////////////not used yet
void rotation()
{
    if(current_theta-FIRtheta[0]>FIR_Thresh[0]) {
        while(FIRtheta[0]<current_theta) { //new_disctrete..........................................................
            RotateRight(0.9,0.9);
            Distance_calculation();
            get_theta();
        }
    } else if(current_theta-FIRtheta[0]<-1*FIR_Thresh[0]) {
        while(FIRtheta[0]>current_theta) {
            RotateLeft(0.9,0.9);
            Distance_calculation();
            get_theta();
        }
    } else {
//        ////xbee.puts("will not rotate\r\n");
    }
    theta_update=false;
}
void GTG_mode()
{
    rot_theta=Theta_base_st;
    navigation_model();
    timer.attach(&get_theta, acquizitiontimeinterrupt);
    timer2.attach(&navigation_model, navigationtimeinterrupt);

    errorI=0;
    while(1) {//////////////////////////////////////////////////////////////////////////////////////////////////////////////in diffrent modes
        if(FWM)Wall_Following();
        PWM_cal();
        move(LPWM,RPWM);
        Distance_calculation();
        if(abs(R-(dis+prev_dis[0]))<3)break;
    }//whileloop
    timer.detach();
    timer2.detach();
    Stop();
    reset_parameters();
}
void FollowWall()
{
    if(Fobstacles_dis<delta&&Fobstacles_dis>0&&!(cw&&Robstacles_dis==-1||ccw&&Lobstacles_dis==-1))First_FW();
    //else if(FWM)Wall_Following();

}
void Wall_Following()
{
    if(Obs_dis>0) { //clockwise
        current_Obs_dis=Robstacles_dis;
        cw=true;
        ccw=false;
        if(current_Obs_dis==0||current_Obs_dis==-1)
            current_Obs_dis=150;//check conditions in this line
    } else if(Obs_dis<0) { //anti clock wise
        current_Obs_dis=-1*Lobstacles_dis;
        cw=false;
        ccw=true;
        if(current_Obs_dis==0||current_Obs_dis==1)current_Obs_dis=-150;//check conditions in this line
    }

    Obs_h=current_Obs_dis-Obs_dis;
    gradient_Obs=2/(1+exp(-0.05*Obs_h))-1;
    //current_theta=current_theta+3.14*(gradient_Obs);//from here we shall begin.
    h_Obsinv=-log(4/(gradient_Obs+2)-1);
    error_inv=(h_Obsinv-0.01*errorI)/6;
    current_theta=error_inv+current_theta;
//we should write here exiting condition.
    GTGtheta=atan2(post_dis[2],post_dis[1]);
    dot_product_cond=cos(current_theta-GTGtheta);
    if((dot_product_cond>0)&&(post_dis[0]<Xtow)&&(abs(current_Obs_dis)>60)) {
        FWM=false;
        GTGM=true;
    }
}
void First_FW()
{
    Xtow=post_dis[0];//check if there is a proper plase to put Xtow more than this
    Obs_adj=Fobstacles_dis;
    min_Obs_opp();
    Obs_hyp=sqrt(Obs_adj*Obs_adj+Obs_opp*Obs_opp);
    Obs_dis=Obs_adj*Obs_opp/Obs_hyp;

    Obs_alpha_opp=sqrt(Obs_adj*Obs_adj-Obs_dis*Obs_dis);
    Obs_alpha=atan2(Obs_alpha_opp,Obs_dis);

    if(Obs_alpha<3.1415/2)
        Obs_alpha= Obs_alpha-1.57079;
    else if(Obs_alpha>3.1415/2)
        Obs_alpha= 3.1415-Obs_alpha;
    if(Obs_alpha<0.0698&&Obs_alpha>-1*0.0698)
        Obs_alpha=1.57079;
    current_theta=current_theta+Obs_alpha;//FWtheta;
    if(Obs_dis==0)Obs_dis=Obs_adj;//done.

    FWM=true;
    GTGM=false;
    //exiting conditions.
    GTGtheta=atan2(post_dis[2],post_dis[1]);
    dot_product_cond=cos(current_theta-GTGtheta);//dot product check.
    if((dot_product_cond>0)&&(post_dis[0]<Xtow)&&(abs(current_Obs_dis)>60)) {
        FWM=false;
        GTGM=true;
    }
}
void min_Obs_opp()
{
    if(Robstacles_dis<0&&Lobstacles_dis<0)Obs_opp=0;
    else if(Robstacles_dis<0&&Lobstacles_dis>0)Obs_opp=-1*Lobstacles_dis;
    else if(Robstacles_dis>0&&Lobstacles_dis<0)Obs_opp=Robstacles_dis;
    else if(Robstacles_dis>0&&Lobstacles_dis>0)Obs_opp = Lobstacles_dis>Robstacles_dis ? Robstacles_dis : -1*Lobstacles_dis;
}
void navigation_model()   //edit here
{
    prev_dis[1]=prev_dis[1]+dis*cos(FIRtheta[0]);
    prev_dis[2]=prev_dis[2]+dis*sin(FIRtheta[0]);
    prev_dis[0]=sqrt(prev_dis[1]*prev_dis[1]+prev_dis[2]*prev_dis[2]);

    post_dis[1]=R*cos(rot_theta)-prev_dis[1];
    post_dis[2]=R*sin(rot_theta)-prev_dis[2];
    post_dis[0]=sqrt(post_dis[1]*post_dis[1]+post_dis[2]*post_dis[2]);
    if(FWM&&!GTGM||Fobstacles_dis<delta&&Fobstacles_dis>0&&post_dis[0]>Fobstacles_dis)//check conditions in this line
        FollowWall();
    if(GTGM&&!FWM) {
        current_theta=atan2(post_dis[2],post_dis[1]);
        Obs_alpha=0;
        ccw=false;
        cw=false;
    }
    leftBackQei.reset();
    rightBackQei.reset();
    dis=0;

    theta_update=true;
}
void compass_mean(int j,float *vec)
{
    float vector1[3]= {0,0,0};
    for(int i=0; i<3; i++) {
        vec[i]=0;
    }
    int k=0;
    while(k<j) {
        SS.Readcompass(vector1);
        for(int i=0; i<3; i++) {
            vec[i]=vec[i]+vector1[i];
        }
        k++;
    }
    for(int i=0; i<3; i++) {
        vec[i]=vec[i]/(j);
    }
}

void elepsoidToCircle()
{
    compass[1]=(compass[1]-0.4301)/0.15;
    compass[2]=(compass[2]+0.1641)/0.15;

}
void North_facing()
{
    northfacing=true;
    get_theta();
    current_theta=0;//3.14*0.5;//atan2(compass[2],compass[1]);
    rotation();
    Stop();
    FIRtheta[0]=FIRtheta[0]-current_theta;
    northfacing=false;
}
//////////////////////////////////////////////////////////////////initialization functions
void Group_CenterInitialize()
{
//for rov1
    PRC[0][0]=DWR[0][0]/20;//(DWR[0][0]+DWR[1][0]-DWR[2][0])/20;
    PRC[0][1]=DWR[0][1]/20;//(DWR[0][1]+DWR[1][1]-DWR[2][1])/20;
//for rov2
    PRC[1][0]=-DWR[0][0]/20;//(DWR[1][0]+DWR[2][0]-DWR[0][0])/20;
    PRC[1][1]=-DWR[0][1]/20;//(DWR[1][1]+DWR[2][1]-DWR[0][1])/20;

//for rov3
    PRC[2][0]=(DWR[2][0]+DWR[0][0]-DWR[1][0])/20;
    PRC[2][1]=(DWR[2][1]+DWR[0][1]-DWR[1][1])/20;

    Go_to_relative_initialized_position();
    //North_facing();

    initialization_state=true;
}
void Go_to_relative_initialized_position()
{
    if(SHAPE=='T') {
//for rov1
        if(rovID==1) {
            X=0-PRC[0][0];
            Y=30-PRC[0][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }
//for rov2
        else if(rovID==2) {
            X=30-PRC[1][0];
            Y=-10-PRC[1][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }
//for rov3
        else if(rovID==3) {
            X=-30-PRC[2][0];
            Y=-10-PRC[2][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }

    } else if(SHAPE=='L') {
        //for rov1
        if(rovID==1) {
            X=30-PRC[0][0];
            Y=0-PRC[0][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }
        //for rov2
        if(rovID==2) {
            X=-30-PRC[1][0];
            Y=0-PRC[1][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }
        //for rov3
        if(rovID==3) {
            X=0-PRC[2][0];
            Y=0-PRC[2][1];
            R=sqrt(X*X+Y*Y);
            Theta_base_st=atan2(X,Y);
            GTG_mode();
        }
    }
}

//////////////////////////////////////////////////////////////////end initialization functions

void reset_parameters()
{
}

void Communication()
{
    char ProcessedString[100];
    if(NoOtherComm) {
        if(xbee.readable()) {
            xbee.gets(ProcessedString,'e');
            printf("\r\n%s\r\n",ProcessedString);
            if(ProcessedString[0]!=Inatialize) return;
            TDM_Communication(ProcessedString);
        }
    }
}

void TDM_Communication(char S[])
{
  //  if(NoOtherComm&&CanComm) {
        char StringToSend[100];
    //    NoOtherComm=false;
        //send mode
        //printf("/n/n/r%c/n/n/r",S[2]);
        //receive mode
        int i=0;
LABEL1:
        while (i<strlen(S)) {
            if(S[i]==BroadcastAddress|| S[i]==ID&&i>=2)
                break;
            else i++;
        }

        //printf("/n/n/r%i  %c/n/n/r",i,S[i-2]);
        switch (S[i-2]) {
            case StopOtherComm :
                CanComm=false;
                break;

            case Inatialize :
                GetCoordinates(S,X12,X23,X13,Y12,Y23,Y13,i-2);
                DWR[0][0]=X12;DWR[0][1]=X23;DWR[1][0]=X13;DWR[1][1]=Y12;DWR[2][0]=Y23;DWR[2][1]=Y13;
                Intializzed=true;
                //printf("\n\rGo to function\n\r");
                break;

            case ACK :
                CanComm=true;
                break;

            case YouCanComm :
                Periorty+=1;
                CanComm=true;
                break;

            case OnlineUpdate :
                ParseRoverData(S,i-2);
                break;

            case mode :
                switch (S[i+1]) {
                    case GroupHeading :
                        float XGH,YGH;
                        ParseXYGH(XGH,YGH,S,i);
                        Group_Heading=true;
                        //put group heading function here
                        break;
                };
                break;

            default :
                i++;
                goto LABEL1;
        };
        
        /*
        if(Periorty==2) {
            if(!SendMode) {
                GetRoverData(StringToSend);
                xbee.printf("%s",StringToSend);
                wait(0.07);
                Periorty=0;
                char temp[6];
                temp[0]=YouCanComm;
                temp[1]=ID;
                temp[2]=BroadcastAddress;
                temp[3]=Delimitier;
                temp[4]='\n';
                temp[5]=NULL;
                xbee.printf("%s",temp);


            }
        } else {
            FarmatXYGH(StringToSend);
            xbee.printf("%s",StringToSend);
            SendMode=false;
        }
    }
    NoOtherComm=true;*/
}

void FormatCoordinates(char String[],float X12,float X23,float X13,float Y12,float Y23,float Y13)
{
    int length=4;
    String[0]='A';
    String[1]='1';
    String[2]='2';
    String[3]='X';
    put_value(String,length ,X12);
    String[length++]='Y';
    put_value(String,length ,Y12);
    String[length++]='A';
    String[length++]='2';
    String[length++]='3';
    String[length++]='X';
    put_value(String,length ,X23);
    String[length++]='Y';
    put_value(String,length ,Y23);
    String[length++]='A';
    String[length++]='1';
    String[length++]='3';
    String[length++]='X';
    put_value(String,length ,X13);
    String[length++]='Y';
    put_value(String,length ,Y13);
    String[length++]=Delimitier;
    String[length++]='\n';
    String[length]=NULL;
}
void put_value(char String[],int & length ,float Z)
{
    char tempS[100];
    sprintf(tempS,"%3f",Z);
    //printf("%s",tempS);
    int NUM_Bytes=strlen(tempS);
    for (int i=length; i<length+NUM_Bytes-1; i++)
        String[i]=tempS[i-length];
    length+=NUM_Bytes-1;
}

void ParseRoverData(char S[],int i)
{
    int j=i;
    RoverDataX[GetNum(S[1+i])]=GetValue('X','Y',S,j);
    RoverDataY[GetNum(S[1+i])]=GetValue('Y',Delimitier,S,j);
}
void ParseXYGH(float &X,float &Y,char S[],int i)
{
    int j=i;
    X=GetValue('X','Y',S,j);
    Y=GetValue('Y',Delimitier,S,j);
}
void GetCoordinates(char S[],float &X12,float &X23,float &X13,float &Y12,float &Y23,float& Y13,int i)
{
    int j=i;
    if(S[i+3]=='T'||S[i+3]=='t')SHAPE='T';
    if(S[i+3]=='L'||S[i+3]=='l')SHAPE='L';
    for (j=i; j<strlen(S); j++)
        if(S[j]=='A')break;
    if(S[j+1]=='1'&&S[j+2]=='2') {
        X12=GetValue('X','Y',S,j);
        Y12=GetValue('Y','A',S,j);
    }
    if(S[j+1]=='2'&&S[j+2]=='3') {
        X23=GetValue('X','Y',S,j);
        Y23=GetValue('Y','A',S,j);
    }
    if(S[j+1]=='1'&&S[j+2]=='3') {
        X13=GetValue('X','Y',S,j);
        Y13=GetValue('Y',Delimitier,S,j);
    }
}

void GetRoverData(char S[])
{
    S[0]=OnlineUpdate ;
    S[1]=ID;
    S[2]=BroadcastAddress;
    S[3]='X';
    char tempS[10];
    int length=4;
    sprintf(tempS,"%3f",X);
    int NUM_Bytes=strlen(tempS);
    for (int i=length; i<length+NUM_Bytes-1; i++)
        S[i]=tempS[i-length];
    length+=NUM_Bytes;
    S[length++]='Y';
    char tempS1[10];
    sprintf(tempS1,"%3f",Y);
    NUM_Bytes=strlen(tempS1);
    for (int i=length; i<length+NUM_Bytes-1; i++)
        S[i]=tempS1[i-length];
    S[length+NUM_Bytes]=Delimitier;
    S[length+NUM_Bytes+1]='\n';
    S[length+NUM_Bytes+2]=NULL;

}

void FarmatXYGH(char S[])
{
    S[0]=mode ;
    S[1]=ID;
    S[2]=BroadcastAddress;
    S[3]=GroupHeading;
    S[4]='X';
    char tempS[10];
    int length=5;
    sprintf(tempS,"%3f",X);
    int NUM_Bytes=strlen(tempS);
    for (int i=length; i<length+NUM_Bytes-1; i++)
        S[i]=tempS[i-length];
    length+=NUM_Bytes;
    S[length++]='Y';
    char tempS1[10];
    sprintf(tempS1,"%4f",Y);
    NUM_Bytes=strlen(tempS1);
    for (int i=length; i<length+NUM_Bytes-1; i++)
        S[i]=tempS1[i-length];
    S[length+NUM_Bytes]=Delimitier;
    S[length+NUM_Bytes+1]='\n';
    S[length+NUM_Bytes+2]=NULL;

}

int GetNum(char c)
{
    switch (c) {
        case '0':
            return 0;
        case '3':
            return 2;
        case '2':
            return 1;
        case '1':
            return 0;
        default:
            return 0;
    };
}

float GetValue(char b,char e,char S[],int &i)
{
    int k,j;
    char s[10];
    for (j=i; j<strlen(S); j++)
        if(S[j]==b)break;
    k=j+1;
    for (j=k; j<strlen(S); j++)
        if(S[j]==e)break;
    int a;
    for (a=k; a<j-1; a++)
        s[a-k]=S[a];
    s[a-k]=NULL;
    i=j;
    return atof(s);
}
