#include "mbed.h"
#include "SI1143.h"

SI1143 sensor(p28, p27);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int main()
{
    int sense1,sense2,sense3;
    
    // Setup the baseline
    sensor.bias(1,5);
    wait(1);
    
    while(1)
    {
        // Read each led sensor
        sense1 = sensor.get_ps1(1);
        sense2 = sensor.get_ps2(1);
        sense3 = sensor.get_ps3(1);
        
        // Can be changed for different sensitivity
        if (sense1 > 80 || sense2 > 80 || sense3 > 80)
        {
            if (sense1 > sense2 && sense1 > sense3)
            {
                led1=1;
                led2=0;
                led3=0;
            }
            
            else if(sense2 > sense1 && sense2 > sense3)
            {
                led1=0;
                led2=1;
                led3=0;
            }
            
            else if(sense3 > sense1 && sense3 > sense2)
            {
                led1=0;
                led2=0;
                led3=1;
            }
        }
        
        else
        {
            led1=0;
            led2=0;
            led3=0;
        }
        
        //Numeriacl output through terminal
        printf("%d-%d-%d\r\n",sense1,sense2,sense3);
    }
}
