#include "mbed.h"
#include "MSCFileSystem.h"

class Watchdog {
public:
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
        LPC_WDT->WDTC = s * (float)clk;         
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
        kick();
    }
    
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
}; 

//Declare interrupt pin 
InterruptIn killSwitch(p21);

//USB Setup 
DigitalOut USBSelect(p24);

//Stopwatch timer
Timer toothTime; 
Timer loopTime;

//Watchdog
Watchdog wdt;

//Battery Level Input
AnalogIn battery(p20);

//Indicator Lights
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3); 

CANMessage msg;

//Analog Mux
AnalogIn analogIn(p15);
//AnalogOut analogOut (p18);

DigitalOut enA (p10);
BusOut selectAnalog (p11,p12,p13,p14);

//Digital Mux
DigitalIn digitalIn (p16);
//DigitalOut digitalOut (p17);

DigitalOut enD (p5);
BusOut selectDigital (p6,p7,p8,p9);

//CAN communication
CAN can1 (p30,p29);
DigitalOut canEn (p26);

//Variables

int gearH, gearL, gearR, gearPos, fuel1, fuel2, fuel3, fuel4, fuel5, fuelLev;
int teethMotor, teethB;
int dataCollectTime;
int count, i,j,x,y;
int variable=0;
int timeCAN = 0; 
int TIME_CAN_MAX = 1000;

double x1, y1, z1, x2, y2, z2;
double temp, clutch,vBatt, vBattery, batteryVoltage;
double susp1, susp2, susp3, susp4;
double circumfB,diameter, backSpeed, frontSpeed, rpmMotor, motorRPM;
double timeA, timeout1, timeLoop; 

char filename[64];
char date[32];
char time1[32];
char time2[32];
char time3[32];
char dataCAN[8];
char batLev, gearPosition, fuelLevel, rpm_motor, temperature, wheelSpeed;


//Interrupt Routine
void trigger() { 
     FILE *fp = fopen(filename, "a+"); //open file and add to it  
     if(fp){  
        fprintf(fp,"%s,%d,%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f \n",time3, gearPos,fuelLev,backSpeed,frontSpeed,motorRPM,x1,y1,z1,x2,y2,z2,temp,clutch,batteryVoltage);             
        fclose(fp);
     } 
     wait(5); //wait for power to turn off
}


void countTeeth(){
    count = 8;
    timeout1 = 1; 
    toothTime.start(); 
    x = digitalIn.read();     
    y = digitalIn.read();
    while(count > 0 & toothTime.read() < timeout1){
        if (x != y){
            count--;
            x=y;
        }
        y = digitalIn.read();
    }       
    timeA = toothTime.read();
}


//Polling Routine
void Polling(){
                
   //Speed 1 - back wheel
        diameter = 0.58; //in kilometers
        teethB = 4;  
        selectDigital = 12;
        wait_us(0.05);   
              
        countTeeth(); 
        if(timeA > timeout1){
            backSpeed = 0; //car not moving!!!
        }else{
            backSpeed = (1/timeA)*3.14*diameter*3.6; //km/hr
        }  
        toothTime.reset();   
                                  
    //Reverse Gear
        selectDigital = 0;
        wait_us(0.05);
        gearR = digitalIn.read();
            
    //Low Gear     
        selectDigital = 1;
        wait_us(0.05);
        gearL = digitalIn.read();

    //High Gear 
        selectDigital = 2;
        wait_us(0.05);
        gearH = digitalIn.read();
                           
    //Fuel 5      
        selectDigital = 3;
        wait_us(0.05);
        fuel5 = digitalIn.read();

    //Fuel 4                   
        selectDigital = 4;
        wait_us(0.05);
        fuel4 = digitalIn.read();
 
     //Fuel 3 
        selectDigital = 5;
        wait_us(0.05);
        fuel3 = digitalIn.read();      
                           
     //Fuel 2         
        selectDigital = 6;
        wait_us(0.05);
        fuel2 = digitalIn.read();
         
     //Fuel 1
        selectDigital = 7;
        wait_us(0.05);
        fuel1 = digitalIn.read();
              
     //Motor rpm
        circumfB = 0.58/1000; //in kilometers
        teethMotor = 12;  
        selectDigital = 11;
        wait_us(0.05);   
              
        countTeeth(); 
        if(timeA > timeout1){
            motorRPM = 0; //motor not moving!!!
        }else{
          motorRPM = 60/(timeA*3); //rev/min
        }  
        toothTime.reset();          
       
                    
     //Clutch
        selectAnalog = 15;
        wait_us(0.05);
        clutch = analogIn.read(); 

     //Accelerometer x1   
        selectAnalog = 0;
        wait_us(0.05);
        x1 = analogIn.read(); 
               
     //Accelerometer y1            
        selectAnalog = 1;
        wait_us(0.05);
        y1 = analogIn.read(); 
        
     //Accelerometer z1
                       
        selectAnalog = 2;
        wait_us(0.05);
        z1 = analogIn.read(); 
                    
     //Temperature (sig4)                
        selectAnalog = 8;
        wait_us(0.05);
        temp = analogIn.read(); 
                    
     //Battery Level
        vBatt = battery.read();
                                
/*       
     //Suspension 1                     
        selectAnalog = 11;  
        wait_us(0.05);                             
        susp1 = analogIn.read(); 
                               
     //Suspension 2
        selectAnalog = 12;                       
        wait_us(0.05);         
        susp2 = analogIn.read(); 
                 
     //Suspension 3                      
        selectAnalog = 13; 
        wait_us(0.05);
        susp3 = analogIn.read(); 
                      
     //Suspension 4
        selectAnalog = 14; 
        wait_us(0.05);
        susp4 = analogIn.read(); 
*/
}

void translateData(){

//convert to gear
    gearPos = 0; // N 
    if (gearL==0){
        gearPos = 1;
    }
    if (gearH==0){
        gearPos = 2;
    }
    if (gearR==0){
        gearPos = 3; 
    }

//convert to fuel level 1-4 (1=Empty 5=Full)
    fuelLev = 5; //Full 
    
    if (fuel1==1){
        fuelLev = 4; 
    }
    if (fuel2==1){
        fuelLev = 3; 
    }
    if (fuel3==1){
        fuelLev = 2; 
    }
    if (fuel4==1){
        fuelLev = 1; 
    }
    if (fuel5==1){
        fuelLev = 0; //Empty 
    }

//convert battery voltage (82=10V & 100=15V)    
    vBattery = vBatt * 100;
    if(vBattery < 82){
        vBattery = 82;
    }
    batteryVoltage = vBatt * 14.8; //change battery % to volts 

//convert motor rpm 0-40 thousand rpm
    rpmMotor = motorRPM/100; //0-40
    if(rpmMotor > 40){
        rpmMotor = 40; 
    }

//convert wheel speed (0-150 km/hr)
    if(backSpeed > 150){
        backSpeed = 150; 
    }

//convert temperature (0-180 degrees C)

//convert clutch position

//convert accelerometer values

}

void getCAN(){
 //Request Data from Display
    while(!can1.read(msg) && (timeCAN < TIME_CAN_MAX) ){
        timeCAN++;//wait until data is received
    }
     
    if(timeCAN < TIME_CAN_MAX){
        variable = msg.data[0];//if data is received store (x2, y2, z2, frontSpeed)
        printf("CAN message received: %d, %d, %d, %d id:%d\r\n", variable, msg.data[1],msg.data[2],msg.data[3],msg.id);
        x2 = msg.data[1];
        y2 = msg.data[2];
        z2 = msg.data[3];
        frontSpeed = msg.data[4];
        
    }else{
        printf("CAN message timeout\r\n");
        x2 = NULL;//if no data timeout and store as null
        y2 = NULL;
        z2 = NULL;
        frontSpeed = NULL;
    }
     
    timeCAN = 0;
}

//Send data to Display
void sendCAN(){      
    
 //Cast to char
    batLev = (char) vBattery; //82-100
    gearPosition = (char) gearPos; //0-3
    fuelLevel = (char) fuelLev; //0-5
    rpm_motor = (char) rpmMotor; //0-40
    temperature = (char) temp; //0-180
    wheelSpeed = (char) backSpeed; //0-150
    
    char dataCAN[8] = {rpm_motor,fuelLevel,gearPosition,batLev,temperature, wheelSpeed,0,0};
    
//send data to display (gearPos, fuelLev, backSpeed, rpmMotor, batLev, temp)
    if (can1.write(CANMessage(0xFF01FF, dataCAN, 8, CANData, CANExtended))){
        //CAN message sent
    }else{ 
        //CAN message not sent
    } 
    timeLoop = loopTime.read(); 
    j--; 
    wait(0.1);

}

//*****************************************************************Main Program*************************************************************************************************

int main() { 
    wdt.kick(5.0); 
    killSwitch.rise(&trigger);
    loopTime.start();
    USBSelect = 0; //enable USB channel 1
    enA = 1; //enable analog mux
    enD = 1; //enable digital mux    
    canEn = 0; //enable CAN
    can1.frequency(250000); 
     
//Set Time and Date
//*****DO THIS THE FIRST TIME ONLY!********
    //set_time(1328382900); //seconds since Jan. 1, 1970 - use Unix Time Converter http://www.epochconverter.com/  
    //started on Feb. 4, 2012 at 19:15:00      
    
    while(1){   //while forever

//Create File 
        time_t seconds = time(NULL);
        strftime(time1, 32, "%H_%M_%S", localtime(&seconds));
        strftime(date, 32, "%m/%d/%y", localtime(&seconds));
        sprintf(filename, "/fs/%s.csv", time1);
        MSCFileSystem fs("fs");
        FILE *fp = fopen(filename, "w"); 
        if(fp){
            fprintf(fp,"Date(MM/DD/YY): %s \n", date); 
            strftime(time2, 32, "%H:%M:%S", localtime(&seconds));
            fprintf(fp,"Start Time: %s \n", time2);
            fprintf(fp,"Time, Gear Position, Fuel Level,Back Wheel Speed(km/h),Front Wheel Speed(km/h),Motor RPM,x1,y1,z1,x2,y2,z2,Temperature(C),Clutch Position(cm),Battery(V) \n"); 
            fclose(fp); 
        }else{//no USB                
        }
          
        i=100; //print to USB file 100 times before opening a new file 
        while(i > 0){
        //Get a CAN message
            getCAN();      
        //Get sensor data  
            Polling();
        //Translate raw sensor data    
            translateData();  
        //Print to USB     
            if(fp != NULL){
                FILE *fp = fopen("/fs/data.csv", "a+");
                time_t seconds = time(NULL);
                strftime(time3, 32, "%H:%M:%S", localtime(&seconds));
                fprintf(fp,"%s,%d,%d,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f,%.2f \n",time3, gearPos,fuelLev,backSpeed,frontSpeed,motorRPM,x1,y1,z1,x2,y2,z2,temp,clutch,batteryVoltage);
                fclose(fp);
                fp = NULL; 
                
            }else{//no USB 
            }
            
        //Send a CAN message
            sendCAN(); 
            i--;
       } //close while i loop 
      
        timeLoop = loopTime.read(); 
        loopTime.reset(); 
        
        wdt.kick();   
    }//close forever while loop        
}//close main