// Project: Nokia5110 - Controlling a NK5110 display from an NXP LPC1768
// File: main.cpp
// Author: Krissi Yan
// Created: January, 2016
// Revised: 
//  Desc: A basic LCD output test which uses the NXP LPC1768's SPI interface to 
//      display pixels, characters, and numbers on the Nokia 5110 LCD.
//      Created using a sparkfun breakout board with integrated Phillips 8544 driver
//      for 48x84 LCDs.

#include "mbed.h"
#include "NOKIA_5110.h"

int main()
{
    // Init the data structures and NokiaLcd class
    LcdPins myPins;
    myPins.sce  = p8;
    myPins.rst  = p9;
    myPins.dc   = p10;
    myPins.mosi = p11;
    myPins.miso = NC;
    myPins.sclk = p13;
    
    NokiaLcd myLcd( myPins );
    
    // Start the LCD
    myLcd.InitLcd();

    // Draw a test pattern on the LCD and stall for 15 seconds
    myLcd.TestLcd( 0xF0 );
    wait( 15 );
    
    // Turn off the LCD and enter an endless loop
    myLcd.ShutdownLcd();
    while( 1 )
    {   
        //dance
    }
}