#include "mbed.h"
#include "math.h"
#include <FT_LSM6DS0.h>

I2C i2c(I2C_SDA, I2C_SCL);
 
DigitalOut myled(LED1);
 
Serial pc(SERIAL_TX, SERIAL_RX);
 
int main()
{
    char data_write[6];
    char data_read[6];
    short X_Acc, Y_Acc;
    float alpha;
    
  data_write[0] = LSM6DS0_WHO_AM_I;
        i2c.write(LSM6DS0_ADDR, data_write, 1, 1); // no stop
        i2c.read(LSM6DS0_ADDR, data_read, 2, 0);
        
        pc.printf("who am I= %2x%c%c",data_read[0],0x0D,0X0A);
        
        data_write[0]=LSM6DS0_CTRL_REG6_XL;
        data_write[1]=0x20; // Set output Data Rate to 10Hz, exiting sleep mode
        
        i2c.write(LSM6DS0_ADDR, data_write,2,0);
        
        data_write[0]=LSM6DS0_CTRL_REG5_XL;
        data_write[1]=0xD8;         //Enable X-Axis Accelerometer
        
        i2c.write(LSM6DS0_ADDR, data_write,2,0);
        
  while(1)
  {
        data_write[0]=LSM6DS0_OUT_X_XL;
        i2c.write(LSM6DS0_ADDR, data_write, 1, 1); // no stop
        i2c.read(LSM6DS0_ADDR, data_read,4,0);
       
       X_Acc= (short)(((unsigned char)data_read[1]) << 8 | ((unsigned char)data_read[0])); 
       Y_Acc= (short)(((unsigned char)data_read[3]) << 8 | ((unsigned char)data_read[2])); 
       
       alpha= 180*atan2((double)Y_Acc,(double)X_Acc)/3.14159;
       
       pc.printf("X_Acc= %d Y_Acc= %d alpha= %.2f \n",X_Acc,Y_Acc,alpha);
         wait(1);
        }
        
}