#include "mbed.h"
#include "MODSERIAL.h"

DigitalOut M1_rotate(D2); // voltage only base rotation
PwmOut M1_Speed(D3);      // voltage only base rotation

DigitalOut M2_rotate(D4);   // encoder side pot 2 translation
PwmOut M2_Speed(D5);        // encoder side pot 2 translation

DigitalOut M3_rotate(D7);   // encoder side pot 1 spatel rotation
PwmOut M3_Speed(D6);        // encoder side pot 1 spatel rotation

//DigitalOut M2_rotate(D6);
//PwmOut M2_Speed(D7);

AnalogIn pot1(A4); // pot 1 motor 1
AnalogIn pot2(A3); // pot 2 motor 3

MODSERIAL pc(USBTX, USBRX);

DigitalIn sw2(SW2); // motor 2 off/on

int main()
{
    pc.baud(115200);
    pc.printf("hoi\n");
    M1_rotate = 1;
    M2_rotate = 1;
    M3_rotate = 1;

    while (true) {
        
        if (sw2 == 1) {
            M2_Speed = 1;
        }
        float M2 = M2_rotate.read();
        float potje1 = pot1.read();
        float potje2 = pot2.read();
        M1_Speed.write(potje1);
        M3_Speed.write(potje2);
        wait(0.1);
        pc.printf("motor 1 %f, motor 2 %f, motor 3 %f \n \r ", potje1, M2, potje2);
    }
}
