#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "mbed_rpc.h"
#include "RpcHandler.h"

RpcDigitalOut led2(LED2, "led2");   // define Rpc digital output object
HTTPServer svr;         //  define HTTP server object
EthernetInterface eth;  // create ethernet interface
Serial pc(USBTX, USBRX);

int main(){

    pc.baud(115200);
    pc.printf("does it work? ");
    
    RPC::add_rpc_class<RpcDigitalOut>();
    eth.init("192.168.1.101"," 255.255.255.0"," 192.168.1.27");  // initialise interface with DCHP ("192.168.1.101"," 255.255.255.0"," 192.168.1.27")
    eth.connect();      // connect and open communications
    pc.printf("IP Address is %s\n", eth.getIPAddress());   // display IP address
    svr.addHandler<HTTPRpcRequestHandler>("/rpc");  // add handler to server object
    svr.start(80, &eth); // bind server to port 80
    
        while(1)
        {
            svr.poll(); // continuously poll for Ethernet messages to server
        }
}

