#include "mbed.h"
#include "TextLCD.h"


TextLCD lcd(D12, D11, D2, D8, D9, D10, TextLCD::LCD16x2);
DigitalOut Sinistra (D6);
DigitalOut Destra (D7);
SPI acc(D4,D5,D3);
DigitalOut cs(PA_15);

int p=0; //indica la posizione della nostra macchinina sulla pista
bool t=false; // poichè usiamo due linee abbiamo la necessità di inserire un blocco da evitare una volta si e una no questa variabile ci serve a questo
char buffer[6];  //buffer data e float che servono nella ricezione dati dall'accelerometro
int16_t data[3];
float x;

void PLACE(int C[16][2])  //questa funzione non fa altro che randomizzare la comparsa dei blocchi da evitare
{
    int i= rand()%2;
    C[0][i]=2;
    return;
}



void Visualizza(int C[16][2])   //Interfaccia che stampa sullo schermo la nostra matrice di gioco. Per velocizzare ho messo prima i 15 blocchi
{
    lcd.cls();                  // dopo il controllo a parte della macchina
    for(int i=0; i<15; i++) {
        for(int j=0; j<2; j++) {
            lcd.locate(i,j);
            if(C[i][j]==2)
                lcd.printf("-");
        }
    }
    for(int i=0; i<2; i++)
        if(C[15][i]==1)
            lcd.printf("<");
    return;
}

bool scrol(int C[16][2],int j)  //questa funzione ci permette di fare uno scroll di tutti i blocchi e un controllo sulla sconfitta
{
    for(int i=14; i>=0; i--) {
        if(C[i][j]==2&&C[i+1][j]==1)
            return false;
        else if(C[i-1][j]==2)
            C[i][j]=2;
        else
            C[i][j]=0;
    }
    return true;
}




void comando()  //questa è da sistemare perchè è possibile inserire il comando ogni scorrimento di blocco, verrebbe meglio con un interrupt.
{
    wait(0.5); //Questo è il tempo che regola tutto il gioco, sarebbe carino inserire un potenziomentro esterno tramite il quale appunto velocizzare o diminuire il tutto.
    cs=0;
    acc.write(0x80|0x40|0x32);
    for (int i = 0; i<=5; i++) {
        buffer[i]=acc.write(0x00);
    }
    cs=1;
    data[0] = buffer[1]<<8 | buffer[0];
    x=0.004*data[0];
    if(x>0.25) {
        Destra=1;
        Sinistra=0;
        p=0;
    } else if(x<-0.25) {
        Sinistra=1;
        Destra=0;
        p=1;
    }
}

bool Excute(int C[16][2])
{
    int h=p;  // controllo per il cambio di posizione
    comando();//chiamata per vedere qual è il comando
    bool ok=true;
    if(p!=h) {
        if(p==0)
            C[15][1]=0;
        else
            C[15][0]=0;
        C[15][p]=1;
    }
    ok=scrol(C,0);
    if(ok) //se l'altra linea ha toppato qui non ci deve proprio entrare.
        ok=scrol(C,1);
    //questo ci serve per il cambio di turno
    if(t==false)
        t=true;
    else
        t=false;
    //riporta nel main la condizione di sconfitta
    if(ok==false)
        return false;
    return true;
}



int main()
{
    int C[16][2]; //Questa è la matrice su cui si svolge il gioco nel caso ci sia memorizzato:
//"1" indica la nostra macchinina
//"2" il blocco contro cui non dobbiamo andare a sbattere.
//Avrei potuto scegliere una matrice di booleani e riconoscere la nostra macchina e i blocchi a seconda della posizione sulle "x" però ho preferito
//utilizzare un int nel caso in futuro volessi aggiornare il gioco con elementi bonus.

    cs=1;
    acc.format(8,3);
    acc.frequency(2000000);
    cs=0;
    acc.write(0x31);
    acc.write(0x0B);
    cs=1;
    cs=0;
    acc.write(0x2D);
    acc.write(0x08);
    cs=1;
//comincia il gioco che va in un loop infinito
    while(true) {
        for(int i=0; i<16; i++) //ogni volta che perdi devi resettare tutte le caselle
            for(int j=0; j<2; j++)
                C[i][j]=0;
        //condizioni iniziali non sono necessarie però preferisco reimpostarle ad ogni sconfitta
        p=0;
        t=0;
        bool ok= true;  //booleana che ci serve per la condizione di sconfitta
        C[15][p]=1; //piazzamento della nostra macchinina
        while(ok) {
            if(t==true) {
                PLACE(C);  //funzione di piazzamento che avviene un ciclo si e uno no
            }
            ok=Excute(C);   //funzione che contiene lo scroll e il controllo della sconfitta
            Visualizza(C);  //funzione di visualizzazione
        }
        //se siamo usciti dal while abbiamo perso ed è bene ricordarlo allo sconfitto
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("GAME OVER");
        wait(3);
    }

}
