#include "LD100_util.h"

void LED_D6(bool OnOff)
{ 
   DigitalOut LED6(D2);
   if (OnOff) 
    LED6 = 1;
   else
    LED6 = 0;
}

DigitalOut resetPin(PA_4);

int TCA6424_init(I2C& i2c_port)
{
    char cmd[4];
    const int saddr = 0x22 << 1;
    resetPin = 1;
    wait_ms(1);    
    resetPin = 0;
    wait_ms(1);    
    resetPin = 1;
    wait_ms(1);    
   
    cmd[0]= 0x05; //Output port 1 
    cmd[1]&= 0x9F; //10011111, set P15, P16 to output low
    i2c_port.write(saddr, cmd, 2);
        
    cmd[0]= 0x0D; //Configuration port 1 
    cmd[1]= 0x9F; //10011111, turn P15, P16 to output pin
    i2c_port.write(saddr, cmd, 2);
  return 0;
}


int TCA6424_init()
{
  I2C i2c_port(I2C_SDA, I2C_SCL);
  return TCA6424_init(i2c_port);
}

void LED_D4(bool OnOff)
{ 
   char cmd[4];
   const int saddr = 0x22 << 1;
   I2C i2c_port(I2C_SDA, I2C_SCL);
  
   cmd[0]= 0x05; //Output port 1 
   i2c_port.write(saddr, cmd, 1);        
   i2c_port.read(saddr, cmd + 1, 1);  //read recent state
    
   cmd[0]= 0x05; //Output port 1 
   if (OnOff)
    cmd[1]|= 0x40; //01000000, set P16 to output High
   else
    cmd[1]&= 0xBF; //10111111, set P16 to output low
   i2c_port.write(saddr, cmd, 2);
}

void LED_D5(bool OnOff)
{ 
   char cmd[4];
   const int saddr = 0x22 << 1;
   I2C i2c_port(I2C_SDA, I2C_SCL);
  
   cmd[0]= 0x05; //Output port 1 
   i2c_port.write(saddr, cmd, 1);        
   i2c_port.read(saddr, cmd + 1, 1);  //read recent state
    
   cmd[0]= 0x05; //Output port 1 
   if (OnOff)
    cmd[1]|= 0x20; //00100000, set P15 to output High
   else
    cmd[1]&= 0xDF; //11011111, set P15 to output low
   i2c_port.write(saddr, cmd, 2);
}


//#define Pin_Charging    IOExpander,ugt::TCA6424_IOPin::P15
//#define Pin_ChargeDone  IOExpander,ugt::TCA6424_IOPin::P16    
