#include "mbed.h"
#include "LSM9DS1.h"
#include <string>
#include <sstream>

Serial  pc(USBTX, USBRX);
Serial  dev(p9,p10);
Timer t1,t2;

using namespace std;

char data;
char goal_val;
char h[10],g[10],w[10];
int total_walktime=0;
float height,weight,goal,goal_f,stride_len,distance_covered,distance_left,calories;

int main()
{
    
    LSM9DS1 IMU(p28, p27, 0xD6, 0x3C);
    
    float curr_value=0.0,last_value=0.0;
    int step=0;
    char data;
    char goal_val;
    char h[10],g[10],w[10];
    int total_walktime=0;
    float height,weight,goal,goal_f,stride_len,distance_covered,distance_left,calories;
    bool flag=0,flag2=0; 
    
    //Initialize and Calibrate IMU
    IMU.begin();  
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    
    //Set baud rate for serial communication to 9600 
    pc.baud(9600);
    dev.baud(9600);
    
    //Get user input data over bluetooth
    dev.printf("Enter weight in pounds: ");   
    dev.gets(w,5);         
    stringstream str(w);
    str>>weight;
    pc.printf("\nWeight = %.3f lbs",weight);   
    
    dev.printf("Enter Height in Inches: ");   
    dev.gets(h,5);         
    stringstream str1(h);
    str1>>height;
    pc.printf("\nHeight = %.3f in",height);   
    stride_len=height*0.413; 
    pc.printf("\nStride_length = %f in", stride_len);
    
    dev.printf("\nEnter Daily Goal in Miles: ");
    dev.gets(g,5);         
    stringstream str2(g);
    str2>>goal;
    pc.printf("\nGoal = %f mi",goal);   
       
    while(1) 
    {   
        //Read accelerometer values from IMU
        while(!IMU.accelAvailable());
        IMU.readAccel();
        wait(.25);
    
        curr_value=IMU.calcAccel(IMU.ax);
       
       //Look for a sharp change in accelerometer output to detect a step  
       if(abs(curr_value-last_value)>0.1)
       {
            step++;
            //Timer t1 keeps track of the total time of movement
            //Timer t2 keeps track of the duration for which the user is stationary
            if(flag==0)
            {
                t1.start();
                flag=1;
                if(flag2==1)
                {
                    flag2=0;
                    t2.stop();
                    t2.reset();
                }
            }  
            total_walktime = t1.read();
        } 
        else
        {
             if(flag==1)
             {
                      if(flag2==0)
                      {
                          t2.start();
                          flag2=1;
                      }
                      if(t2.read()>=3)
                      {
                          flag=0;
                          flag2=0;
                          t2.stop();
                          t2.reset();
                          t1.stop();
                      }
             }  
        }         
       
        last_value = curr_value;
        
        distance_covered = step*stride_len/63360;
        distance_left = goal-distance_covered;
        calories = 0.63*distance_covered*weight;
        
        pc.printf("\nSteps = %d",step);
        pc.printf("\nDistance Covered = %.3f miles",distance_covered);
        pc.printf("\nDistance left to reach your goal = %.3f miles", distance_left);
        pc.printf("\nCalories burnt = %.3f cal",calories);
        pc.printf("\nTotal Walk Time = %d s\n",total_walktime);
    }
}

