#include "mbed.h"
#include "USBKeyboard.h"
#include "TSISensor.h"

#define SWITCH_TIMEOUT 10

USBKeyboard keyboard;

typedef enum 
{
    ACCEPT_VIDEO_CALL,
    ACCCEPT_AUDIO_CALL,
    DECLINE_CALL,
    TOGGLE_MUTE,
    TOGGLE_VIDEO
}CommandList_e;


DigitalIn up(D4);
DigitalIn down(D5);
DigitalIn left(D6);
DigitalIn right(D3);


//PwmOut rled(LED_RED);
//PwmOut gled(LED2);
//PwmOut bled(LED3);

void sendKeyboardCommand(CommandList_e command)
{
    switch(command)
    {
    case ACCEPT_VIDEO_CALL:
        keyboard.keyCode('a',KEY_CTRL|KEY_SHIFT); 
        break;
    case ACCCEPT_AUDIO_CALL:
        keyboard.keyCode('a',KEY_CTRL|KEY_SHIFT); 
        break;
    case DECLINE_CALL:
        keyboard.keyCode('d',KEY_CTRL|KEY_SHIFT); 
        break;
    case TOGGLE_MUTE:
        keyboard.keyCode('m',KEY_CTRL|KEY_SHIFT); 
        break;
    case TOGGLE_VIDEO:
        keyboard.keyCode('o',KEY_CTRL|KEY_SHIFT); 
        break;
    default:
        break;
    };   
}


int main(void)
{
    int switchTime = 0;
    up.mode(PullUp);
    down.mode(PullUp);
    left.mode(PullUp);
    right.mode(PullUp);
    
    while(1)
    {
        if (switchTime == 0)
        {
            if(!up)
            {
                switchTime = SWITCH_TIMEOUT;
                sendKeyboardCommand(TOGGLE_MUTE);
//                keyboard.keyCode(UP_ARROW);
            }
            if(!down)
            {
                switchTime = SWITCH_TIMEOUT;
                sendKeyboardCommand(DECLINE_CALL);
//                keyboard.keyCode(DOWN_ARROW);
            }
            if(!left)
            {
                switchTime = SWITCH_TIMEOUT;
                sendKeyboardCommand(ACCEPT_VIDEO_CALL);
//                keyboard.keyCode(LEFT_ARROW);
            }
            if(!right)
            {
                switchTime = SWITCH_TIMEOUT;
                sendKeyboardCommand(ACCCEPT_AUDIO_CALL);
//                keyboard.keyCode(RIGHT_ARROW);
            }
        }
        else
        {
            switchTime--;
        }
        wait(0.1);
    };
}
    