#include "mbed.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    int on = 0;

    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());

        if((x > 0.5) && (y > 0.5) && (z > 0.5) && (on == 0)) {
            rled = 0;
            gled = 0;
            bled = 0;
            on = 1;
        } 

        else if((x > 0.5) && (y > 0.5) && (z > 0.5) && (on == 1)) {
            rled = 1;
            gled = 1;
            bled = 1;
            on = 0;
        }

        wait (0.7);
        //printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n", x, y, z);
    }
}
