/* mbed audio player
 * Copyright (c) 2010, 2011 Frank Weissenborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
/* This code based on:
 *  Wii Nunchuck
 *  http://mbed.org/users/knaka/libraries/WiiNunchuck/ljkynp
 *  2010-12-18
 */
 
#ifndef __WIICHUCK_H
#define __WIICHUCK_H

#include "mbed.h"

#define NUNCHUCK_ADDR     0xA4  // 0x52 << 1
#define NUNCHUCK_REGADDR  0x40  // 
#define NUNCHUCK_READLEN  0x06  //
#define I2C_ACK 0
#define I2C_READ_DELAY  0.01

#define Joy_X   0
#define Joy_Y   1
#define Acc_X   2
#define Acc_Y   3
#define Acc_Z   4
#define Button  5

// ----------------------------------------------------------------------------
//   Control values
// ----------------------------------------------------------------------------
#define BUTTON_PREV_VALUE               '1'
#define BUTTON_NEXT_VALUE               '2'
#define BUTTON_OK_VALUE                 '3'
#define BUTTON_CANCEL_VALUE             '4'
#define BUTTON_RESET_VALUE              'r'
#define BUTTON_VOLUME_PLUS              '+'
#define BUTTON_VOLUME_MINUS             '-'

typedef void(*pt2Func)(int);

class WiiChuck {
public:
    bool Error;
    WiiChuck(PinName data, PinName clk);
    bool Read(int* joyX,int* joyY,int* accX,int* accY,int* accZ,int* buttonC,int* buttonZ);
    void start();
    void stop();
    void attach(pt2Func function);
private: 
    I2C _i2c;
    pt2Func _callback_input;
    Ticker _getValues;
    void getValues();
    int _oldC;
    int _oldZ;
    

};

#endif