#ifndef __SHOUTCAST_H
#define __SHOUTCAST_H

#include "EthernetNetIf.h"

#include "DNSRequest.h"

#include "defines.h"

class Shoutcast
{
public:
    Shoutcast(const char* devId, char * big_buffer,  int big_buffer_size, char * small_buffer, int small_buffer_size);
    
     /**
     * Get previous genre.
     *
     * @return pointer to null terminatetd string.
     */
    const char* GetPrevGenre();
     /**
     * Get current genre.
     *
     * @return pointer to null terminatetd string.
     */
    const char* GetCurrGenre();
    
     /**
     * Get next genre.
     *
     * @return pointer to null terminatetd string.
     */
    const char* GetNextGenre();
    
    int GetChannel(char* name, int length); //cache
    int GetTop500(char* name, int length);
    
     /**
     * Get previous channel.
     *
     * @param name A target key name.
     * @param length A pointer to a value storage.
     * @return 0, all okay -1, eror getting channel, -2 no channels in list.
     */
    int GetPrevChannel(char* name, int length);
    /**
     * Get current channel.
     *
     * @param name A target key name.
     * @param length A pointer to a value storage.
     * @return 0, all okay -1, eror getting channel, -2 no channels in list.
     */
    int GetCurrChannel(char* name, int length);
    /**
     * Get next channel.
     *
     * @param name A target key name.
     * @param length A pointer to a value storage.
     * @return 0, all okay -1, eror getting channel, -2 no channels in list.
     */
    int GetNextChannel(char* name, int length);
    
     /**
     * Get IP and port of current shoutcast channel.
     *
     * @param address pointer to address.
     * @param port pointer to port.
     * @return 0, all okay -1, error 1, error parsing pls
     */
    int TuneIn(IpAddr* address, int* port, char * path, const int length);
    int GetNextAddress(IpAddr* address, int* port, char * path, const int length);
    int GetCurrAddress(IpAddr* address, int* port, char * path, const int length);
    int GetPrevAddress(IpAddr* address, int* port, char * path, const int length);
    
    
    
private:
    const char* _devId;
    int ParseChannelList(const char* channelList);
    int ParsePls();
    int GetChannel(char* name, int length, int channelNumber);
    int GetAddressData(IpAddr* address, int* port,char * path, const int length, int addressNumber);
    void onReply(DNSReply reply);
    int ResolveDNSRequest(IpAddr* addr, char * url);
    int GetChannelId(int channelNumber);
    char * _big_buffer;
    int _big_buffer_size;
    char * _small_buffer;
    int _small_buffer_size;
    
    unsigned int _genreCounter;
    unsigned int _maxChannel;
    unsigned int _currentChannel;
    unsigned int _maxAddress;
    unsigned int _currentAddress;
    FILE *_fpin;
    FILE *_fpout;
};

#endif