#ifndef __SHOUTCASTCONNECTOR_H
#define __SHOUTCASTCONNECTOR_H


#include "VS1053.h"
#include "TCPSocket.h"

typedef void (*myCallBack_pfn)(const char*, int, int, int);

class ShoutcastConnector
{
public:
    ShoutcastConnector(VS1053* mp3,myCallBack_pfn, char *buffer, int buffer_size);
    int Connect(IpAddr address, int port, const char * path);
    int Disconnect();
private:
    VS1053*                          _mp3;
    myCallBack_pfn                   _callback;
    TCPSocket                        _sock;
    char*                            _buffer;
    int                              _buffer_size;
    const char *                           _path;

    void Writeable();
    void Readable();
    
    void onTCPSocketEvent(TCPSocketEvent e);
};

#endif