#include "DogM16x.h"


DogM16x::DogM16x(PinName db0, PinName db1, PinName db2, PinName db3, PinName rw, PinName rs, PinName enable, PinName reset,DogM16x_TYPE type):_d(db0,db1,db2,db3),_rw(rw),_rs(rs),_enable(enable),_reset(reset) {
    _reset = 1;
    _rw = 0;
    _enable = 0;

    _type = type;
    _xpos = 0;
    _ypos = 0;

    DEBUGOUT("DogM16x: Start init");
    Init();
    DEBUGOUT("DogM16x: End init");
}




void DogM16x::Init() {

    if (_type == DogM16x_DogM161) {
        DEBUGOUT("DogM16x: Not implemented yet");
        return;
    } else {
        _rw = 0;
        _enable = 0;
        _rs = 0;        // RS auf low

        wait_ms(200);
        WriteCommandByte(0x33); // function set lines, interface
        wait_ms(5);
        WriteCommandByte(0x32); // function set lines, interface
        wait_ms(5);
        WriteCommandByte(0x29); // function set lines, interface
        wait_ms(5);
        WriteCommandByte(0x14); // function set bias, OSC
        wait_ms(5);
        WriteCommandByte(0x72);//78// function set contrast
        wait_ms(5);
        WriteCommandByte(0x55);// function set power, icon, contrast
        wait_ms(5);
        WriteCommandByte(0x6E); //6D// function set follower
        wait_ms(5);
        WriteCommandByte(0x0C);// funktion set display on/off
        wait_ms(5);
        WriteCommandByte(0x01); // clear display
        wait_ms(20);
        WriteCommandByte(0x06); // entry mode set
        wait_ms(20);
    }

}

void DogM16x::WriteCommandByte(int cmd) {
    _rs = 0;
    _rw = 0;
    SetData(cmd);
}
void DogM16x::WriteDataByte(int cmd) {
    _rs = 1;
    _rw = 0;
    SetData(cmd);
}

void DogM16x::SetData(int value) {

    _d = ((value & 0xF0)>>4);            // Oberes Nibble
    wait_us(30);         // 30&#65533;s warten
    _enable = 1;                 // Clock-Bit auf high
    wait_us(1);         // High muss min. 200ns anliegen
    _enable = 0;                  // und jetzt auf low

    wait_us(1);         // 30&#65533;s warten
    _d = (value & 0x0F);        // Unteres Nibble
    wait_us(30);         // 30&#65533;s warten
    _enable = 1;                 // Clock-Bit auf high
    wait_us(1);         // High muss min. 200ns anliegen
    _enable = 0;                  // und jetzt auf low
}

/** Clear Display
 *
 * Write spaces into DDRAM and set address to (0,0)
 *
 */
void DogM16x::Clear() {
    WriteCommandByte(0x01);
    wait_ms(2);
    _xpos = 0;
    _ypos = 0;
}

/** Set Position to (x,line)
 *
 * @param x new x position
 * @param line new line
 */
void DogM16x::SetPosition(unsigned char x, DogM16x_LINE line) {

    int distance_per_line = 0;
    if (_type == DogM16x_DogM161) {
        DEBUGOUT("DogM16x: Not implemented yet");
        return;
    }
    if (_type == DogM16x_DogM162) {
        distance_per_line = 40;
    }
    if (_type == DogM16x_DogM163) {
        distance_per_line = 16;
    }

    WriteCommandByte(0x80 + line*distance_per_line + x);
    wait_us(27);
    _xpos = x;
    _ypos = line;
}

/** Write a character at the current position
 *
 * @param character character
 */
void DogM16x::WriteCharacter(char character) {
    if(_xpos < 16) {
     WriteDataByte(character);
     wait_us(27);
     _xpos++;
     }
}

/** Write a character at position (x,line)
 *
 * @param character character
 * @param x x-position (starting with 0)
 * @param line
 */
void DogM16x::WriteCharacter(char character,unsigned char x, DogM16x_LINE line) {
    SetPosition(x,line);
    WriteCharacter(character);
}

/** Write a null terminated string at the current position
 *
 * @param string string
 */
void DogM16x::WriteString(const char* string) {

    _rs = 1;

    while ((string[0]  != 0x00)&&(_xpos < 16)) {
        wait_us(30);
        SetData(string[0]);
        string++;
        _xpos++;
    }
}

/** Write a null terminated string at position (x,line)
 *
 * @param string string
 * @param x x-position (starting with 0)
 * @param line (LINE_1, LINE_2 or LINE3)
 */
void DogM16x::WriteString(const char* string, unsigned char x, DogM16x_LINE line) {
    SetPosition(x,line);
    WriteString(string);
}

void DogM16x::WriteStringCompleteLine(const char* string, DogM16x_LINE line)
{
    WriteStringCompleteLine(string, 0, line);
}

void DogM16x::WriteStringCompleteLine(const char* string, unsigned char x, DogM16x_LINE line)
{
    SetPosition(x,line);
    _rs = 1;

    while ((string[0]  != 0x00)&&(_xpos < 16)) 
    {
        wait_us(30);
        SetData(string[0]);
        string++;
        _xpos++;
    }
    
    while (_xpos < 16) 
    {
        wait_us(30);
        SetData(' ');        
        _xpos++;
    }
}

