/* mbed audio player
 * Copyright (c) 2010, 2011 Frank Weissenborn
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef __DOGM16X_H
#define __DOGM16X_H

#include "defines.h"
#include "mbed.h"
    

typedef enum DogM16x_LINE
{
    DogM16x_LINE_ONE          = 0,           /*!< Line 1 */
    DogM16x_LINE_TWO          = 1,           /*!< Line 2 */
    DogM16x_LINE_THREE        = 2,           /*!< Line 3; if exist */    
} DogM16x_LINE;

typedef enum DogM16x_TYPE
{
    DogM16x_DogM161          = 0,           /*!< DogM161 Display  */
    DogM16x_DogM162          = 1,           /*!< DogM162 Display   */
    DogM16x_DogM163          = 2,           /*!< DogM163 Display  */    
} DogM16x_TYPE;

class DogM16x {
public:    
    DogM16x(PinName db0, PinName db1, PinName db2, PinName db3, PinName rw, PinName rs, PinName enable, PinName reset, DogM16x_TYPE);
    void Clear();
    void SetPosition(unsigned char x, DogM16x_LINE line);
    void WriteCharacter(char character);
    void WriteCharacter(char character, unsigned char x, DogM16x_LINE line);
    void WriteString(const char* string);
    void WriteString(const char* string, unsigned char x, DogM16x_LINE line);
    void WriteStringCompleteLine(const char* string, DogM16x_LINE line);
    void WriteStringCompleteLine(const char* string, unsigned char x, DogM16x_LINE line);
    
  
private: 
    BusOut _d;
    DigitalOut _rw;     
    DigitalOut _rs; 
    DigitalOut _enable; 
    DigitalOut _reset;
    DogM16x_TYPE _type;
    
    unsigned char _xpos;
    unsigned char _ypos;
    
    void Init(); 
    void WriteCommandByte(int cmd);
    void WriteDataByte(int cmd);
    void SetData(int data);
};


#endif
