#ifndef __DOGM163_H
#define __DOGM163_H

#include "mbed.h"

class DogM163 {
public:
    static const unsigned char LINE_1 = 0;
    static const unsigned char LINE_2 = 1;
    static const unsigned char LINE_3 = 2; 
    
    DogM163(PinName miso, PinName clk, PinName cs, PinName rs);
    void Clear();
    void SetPosition(unsigned char x, unsigned char line);
    void WriteCharacter(char character);
    void WriteCharacter(char character,unsigned char x,unsigned char line);
    void WriteString(char* string);
    void WriteString(char* string, unsigned char x, unsigned char line);
    
  
private: 
    SPI _spi;
    DigitalOut _rs;
    DigitalOut _cs;
    
    void Init(); 
    void WriteCommandByte(char cmd);
    void WriteDataByte(char cmd);
};


#endif


