#include "DogM163.h"

DogM163::DogM163(PinName miso, PinName clk, PinName cs, PinName rs):_spi(miso,NC,clk),_rs(rs),_cs(cs) {
    _spi.format(8,0);
    _spi.frequency(250000);
    Init();
}

void DogM163::Init() {
     _cs=0;
    wait_ms(50);
    WriteCommandByte( 0x39 );     // Function set; 8 bit Datenl&#65533;nge, 2 Zeilen, Instruction table 1
    wait_us(27);          // mehr als 26,3&#65533;s warten
    WriteCommandByte( 0x15 );     // Bias Set; BS 1/4; 3 zeiliges Display
    wait_us(30);         // mehr als 26,3&#65533;s warten
    WriteCommandByte( 0x70 );     // Kontrast C3, C2, C1 setzen
    wait_us(30);
    WriteCommandByte( 0x55 );     // Booster aus; Kontrast C5, C4 setzen
    wait_us(30);
    WriteCommandByte( 0x6e );     // Spannungsfolger und Verst&#65533;rkung setzen /6c
    wait_ms(200);               // mehr als 200ms warten !!!
    WriteCommandByte( 0x0f );     // Display EIN, Cursor EIN, Cursor BLINKEN /0f
    wait_us(30);
    WriteCommandByte( 0x01 );     // Display l&#65533;schen, Cursor Home
    wait_ms(50);
    WriteCommandByte( 0x06 );     // Cursor Auto-Increment
    wait_us(30);
    WriteCommandByte( 0x02 );     // Cursor Auto-Increment
    wait_us(30);
    _cs=1;
}

void DogM163::WriteCommandByte(char cmd) {
    _rs = 0;
    _spi.write(cmd);
}
void DogM163::WriteDataByte(char cmd) {
    _rs = 1;
    _spi.write(cmd);
}

/** Clear Display
 * 
 * Write spaces into DDRAM and set address to (0,0) 
 *
 */
void DogM163::Clear()
{
_cs = 0;
WriteCommandByte(0x01);
wait_ms(50);
_cs = 1;
}

/** Set Position to (x,line)
 * 
 * @param x new x position
 * @param line new line (LINE_1,LINE_2 or LINE_3)
 */
void DogM163::SetPosition(unsigned char x, unsigned char line)
{
_cs=0;
WriteCommandByte(0x80 + line*16 + x);
_cs=1;
}

/** Write a character at the current position
 *
 * @param character character
 */
void DogM163::WriteCharacter(char character) {
    _cs=0;
    WriteDataByte(character);
    _cs=1;
}

/** Write a character at position (x,line)
 *
 * @param character character
 * @param x x-position (starting with 0)
 * @param line (LINE_1, LINE_2 or LINE3)
 */
void DogM163::WriteCharacter(char character,unsigned char x,unsigned char line)
{
    SetPosition(x,line);
    WriteCharacter(character);
}

/** Write a null terminated string at the current position
 *
 * @param string string
 */
void DogM163::WriteString(char* string)
{
  _rs = 1;
  _cs = 0;
  while (string[0]  != 0x00)
  {
    wait_us(30);
    _spi.write( string[0] );
    string++;
  }
  _cs = 1;
}

/** Write a null terminated string at position (x,line)
 *
 * @param string string
 * @param x x-position (starting with 0)
 * @param line (LINE_1, LINE_2 or LINE3)
 */
void DogM163::WriteString(char* string, unsigned char x, unsigned char line)
{
    SetPosition(x,line);
    WriteString(string);
}

