#include "mbed.h"
#include <TCPSocketConnection.h>
#include "rtos.h"

#define VARSIZE                                                 3
static char                                                     vars[VARSIZE][50]={"personPassed","lightCondition","humidity"};
int                                                             vals[VARSIZE]={10,20,30};
char                                                            buffer[2048];

void prepareUpdate()
{
    char                                                        tmp[512];
    int                                                         i;
    strcpy(buffer,"<update>\n");
    for (i=0;i<VARSIZE;i++)
    {
        sprintf(tmp,"\t<%s>%d</%s>\n",vars[i],vals[i],vars[i]);
        strcat(buffer,tmp);
    }
    strcat(buffer,"</update>\n");
}

void vTCPSend(char *s,const size_t size)
{
    TCPSocketConnection                                         tcp;
    if (tcp.connect("127.0.0.1",6423)==0)
    {
        size_t                                                  transmitted;
        int                                                     sent=0;
        for (transmitted=0;(transmitted<size)&(sent>=0);transmitted+=sent)
            sent=tcp.send(&s[transmitted],size-transmitted);
    }
    tcp.close();
}

int main(void)
{
    while (1)
    {
        prepareUpdate();
        vTCPSend(buffer,strlen(buffer));
        wait(15);
    }
}

