#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
#include "BMP280.h"
#include <iostream>
#include <string> 

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello World</h1>" "\r\n"                              \
"      <p>The LDR value is "                                     
#define HTTP_MESSAGE_BODY2 ""                                    \
       "</p>" "\r\n"                                             \       
"      <p1>The Temperature value is"                                      
#define HTTP_MESSAGE_BODY6 ""                                    \
       "</p1>" "\r\n"                                            \       
"      <p2>The Pressure value is "                                     
#define HTTP_MESSAGE_BODY4 ""                                    \
       "</p2>" "\r\n"                                            \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"                                   

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define IP        "10.0.0.1"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"

BMP280 bmp(D14,D15,0x76);
AnalogIn ldr(PA_0);


int main()
{
    printf("Basic HTTP server example\n");
    
    //Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    printf("The target IP address is '%s'\n", eth.get_ip_address());
    
    //Now setup a web server
    TCPServer srv;           //TCP/IP Server
    TCPSocket clt_sock;      //Socket for communication
    SocketAddress clt_addr;  //Address of incoming connection
    
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    while (true) {
        using namespace std;
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
        printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
        //Uses a C++ string to make it easier to concatinate
        string response;
        //This is a C string
        char ldr_str[64];
        
        //Read the LDR value
        float u = ldr;
        
        //Convert to a C String
        sprintf(ldr_str, "%5.3f", u );
        printf("LDR: %5.3f\n\r", u);
     
     string response1,response2;
     float tempf = 52, pressuref = 713;
     char data_temp[64] , data_press[64];
     //tempf = bmp.getTemperature();
     //pressuref = bmp.getPressure();
     sprintf(data_temp, "%5.3f", tempf );
     sprintf(data_press, "%5.3f", pressuref );
     

        
        //Build the C++ string response
        response = HTTP_MESSAGE_BODY1;
        response += ldr_str;
        response += HTTP_MESSAGE_BODY2;
        
        
        response1 += data_temp;
        response1 += HTTP_MESSAGE_BODY6;
        
        
        response2 += data_press;
        response2 += HTTP_MESSAGE_BODY4;

        
        //Send static HTML response (as a C string)
        clt_sock.send(response.c_str(), response.size()+6); 
        clt_sock.send(response1.c_str(), response1.size()+6);
        clt_sock.send(response2.c_str(), response2.size()+6);   
    }
}
