#include "mbed.h"
#include "tsi_sensor.h"

void intro();
void me_simon();
void tiempo();
void aleatorio();
void reset_leds();

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif

enum estados_me_simon {E_random,E_rojo,E_azul,E_verde,E_jugador,E_perdedor,E_ganador,E_reinicio};
enum estados_me_simon me_simon_estado=E_random; /*Estado de reset = E_random*/

enum estados_leds {ON,OFF}; /*ON = 0, OFF = 1*/

DigitalOut R(LED_RED);
DigitalOut V(LED_GREEN);
DigitalOut A(LED_BLUE);

#define TLEDS 500
#define SECUENCIAS 10

float slider;

char texto=0;
int introduccion=0;

int color[100];

int numero=0;
int semilla=1;
int memoria=0;
int final=0;
int tmo=0;
int tmoant=1;
int seleccion=0;
int correctas=0;
int incorrectas=0;
int sliderant=0;
int seleccionant=0;
int resultado=0;

Ticker t;
Ticker a;

int main()
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    reset_leds();
    t.attach(&tiempo, 0.001); /*1ms*/
    a.attach(&aleatorio, 0.0001); /*0.1ms*/
    intro();
    while(1) {
        me_simon();
    }
}

/*función de introdución al juego*/
void intro()
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

    printf("Bienvenido al Simon\n\r");
    printf("Quieres aprender a jugar?\n\r");
    printf("Slider Izquierdo(Si) o Slider Derecho(No)\n\r");

    while(introduccion==0) {

        slider = tsi.readPercentage();

        if(slider>0.6 && slider<1) {
            printf("\nWow pues este jugador debe ser un experto\n\r");
            introduccion=1;
        }

        if(slider>0 && slider<0.4) {
            printf("\nEl juego consta de apretar los botones correspondientes a cada color en el orden que las secuencias indiquen una vez estas hayan terminado de reproducirse\n\r");
            printf("A medida que se hagan correctamente las secuencias se pasara a una secuencia con los mismos colores pero agregando uno al final\n\r");
            printf("\nLos botones de los colores son:\n\r");
            printf("Rojo---Izquierdo\n\r");
            printf("Azul---Medio\n\r");
            printf("Verde---Derecho\n\r");
            printf("\nUna vez dicho esto...\n\r");
            introduccion=1;
        }
    }
    introduccion=0;
    while(introduccion==0) {

        slider = tsi.readPercentage();

        if(tmoant > 0) {
            printf("\nSi estas listo, toca el slider\n\r");
            tmo=1000;
            tmoant=0;
        }
        if(slider!=0 && tmo==0) {
            introduccion=1;
            printf("\nCOMIENZA\n\r");
            tmoant=1;
            while(slider!=0)
                slider = tsi.readPercentage();
        }
    }
}

/*decrementa tmo cada 1ms*/
void tiempo()
{
    if (tmo > 0)
        tmo--;
}

/*genera numeros aleatorios entre 1 y 3 cada 0.1ms*/
void aleatorio()
{
    semilla++;
    if(semilla>=3)
        semilla*=semilla;
    if(semilla>=800)
        semilla=1;
    srand(semilla);
    numero= rand()%3+1;
}

/*función para apagar los leds*/
void reset_leds()
{
    R=OFF;
    A=OFF;
    V=OFF;
}

/*máquina de estados del simon*/
void me_simon()
{
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    switch(me_simon_estado) {
        default:
        case E_random:

            /*salidas*/
            reset_leds();

            if(tmoant > 0) {
                tmoant=0;
                tmo=TLEDS;
            }

            /*transición*/

            /*lee los colores generados en las secuencias anteriores*/
            if(memoria!=final && tmo==0 && tmoant==0) {
                if(color[memoria]==1)
                    me_simon_estado=E_rojo;
                if(color[memoria]==2)
                    me_simon_estado=E_azul;
                if(color[memoria]==3)
                    me_simon_estado=E_verde;
                tmoant=1;
            }

            /*genera un nuevo color en base a la variable: numero*/
            if(memoria==final && tmo==0 && tmoant==0) {
                color[final]=numero;
                if(color[final]==1)
                    me_simon_estado=E_rojo;
                if(color[final]==2)
                    me_simon_estado=E_azul;
                if(color[final]==3)
                    me_simon_estado=E_verde;
                tmoant=1;
            }
            break;

        case E_rojo:

            /*salidas*/
            R=ON;
            A=OFF;
            V=OFF;
            if(tmoant > 0) {
                tmoant=0;
                tmo=TLEDS;
            }

            /*transición*/
            if(tmo==0) {
                if(memoria==final) {
                    tmoant=1;
                    memoria=0;
                    me_simon_estado=E_jugador;
                } else {
                    me_simon_estado=E_random;
                    memoria++;
                    tmoant=1;
                }
            }
            break;

        case E_azul:

            /*salidas*/
            R=OFF;
            A=ON;
            V=OFF;
            if(tmoant > 0) {
                tmoant=0;
                tmo=TLEDS;
            }

            /*transición*/
            if(tmo==0) {
                if(memoria==final) {
                    tmoant=1;
                    memoria=0;
                    me_simon_estado=E_jugador;
                } else {
                    me_simon_estado=E_random;
                    memoria++;
                    tmoant=1;
                }
            }
            break;

        case E_verde:

            /*salidas*/
            R=OFF;
            A=OFF;
            V=ON;
            if(tmoant > 0) {
                tmoant=0;
                tmo=TLEDS;
            }

            /*transición*/
            if(tmo==0) {
                if(memoria==final) {
                    tmoant=1;
                    memoria=0;
                    me_simon_estado=E_jugador;
                } else {
                    me_simon_estado=E_random;
                    memoria++;
                    tmoant=1;
                }
            }
            break;

        case E_jugador:

            /*salidas*/
            reset_leds();

            if(tmoant > 0) {
                tmoant=0;
                tmo=TLEDS;
                final++;
            }

            /*transición*/
            if(tmo==0 && tmoant==0) {
                while(correctas<final && incorrectas==0) {

                    slider = tsi.readPercentage();

                    if(slider>0 && slider<0.2 && sliderant==0) {
                        seleccion=1;
                        sliderant=1;
                        seleccionant=0;
                        R=ON;
                        while(slider!=0)
                            slider = tsi.readPercentage();
                    }

                    if(slider>0.35 && slider<0.65 && sliderant==0) {
                        seleccion=2;
                        sliderant=1;
                        seleccionant=0;
                        A=ON;
                        while(slider!=0)
                            slider = tsi.readPercentage();
                    }

                    if(slider>0.8 && slider<1 && sliderant==0) {
                        seleccion=3;
                        sliderant=1;
                        seleccionant=0;
                        V=ON;
                        while(slider!=0)
                            slider = tsi.readPercentage();
                    }

                    if(slider==0) {
                        sliderant=0;
                        reset_leds();
                    }

                    if(seleccion!=color[memoria] && seleccionant==0 && seleccion!=0) {
                        incorrectas=1;
                        seleccionant=1;
                    }
                    if(seleccion==color[memoria] && seleccionant==0 && seleccion!=0) {
                        correctas++;
                        seleccionant=1;
                        memoria++;
                    }

                }
                if(incorrectas==1) {
                    me_simon_estado=E_perdedor;
                    resultado=0;
                }

                if(correctas==SECUENCIAS && incorrectas==0) {
                    me_simon_estado=E_ganador;
                    resultado=0;
                }

                if(correctas<SECUENCIAS && incorrectas==0) {
                    me_simon_estado=E_random;
                    memoria=0;
                    correctas=0;
                    tmoant=1;
                }

                break;

            case E_ganador:
                slider = tsi.readPercentage();

                if(tmoant > 0) {
                    tmo=TLEDS;
                    tmoant=0;
                    texto=0;
                }

                if(slider==0)
                    sliderant=0;

                /*salidas*/
                if(resultado==0) {
                    printf("\nGANASTE\n\r");
                    tmoant=1;
                }
                R=ON;
                A=OFF;
                V=ON;
                resultado=1;

                /*transición*/
                if(tmo==0 && sliderant==0) {
                    printf("\nQuieres jugar de nuevo?\n\r");
                    printf("Toca el slider para reiniciar\n\r");
                    while(texto==0) {
                        slider = tsi.readPercentage();

                        if(slider>0 && slider<0.4) {
                            me_simon_estado=E_reinicio;
                            printf("\nPreparate...\n\r");
                            printf("Toca el slider cuando estes listo\n\r");
                            tmoant=1;
                            texto=1;
                        }
                    }
                    break;

                case E_perdedor:
                    slider = tsi.readPercentage();

                    if(tmoant > 0) {
                        tmo=TLEDS;
                        tmoant=0;
                        texto=0;
                    }

                    if(slider==0)
                        sliderant=0;

                    /*salidas*/
                    if(resultado==0) {
                        printf("\nPERDISTE\n\r");
                        tmoant=1;
                    }
                    R=ON;
                    A=ON;
                    V=OFF;
                    resultado=1;

                    /*transición*/
                    if(tmo==0 && sliderant==0) {
                        printf("\nReintentar?\n\r");
                        printf("Toca el slider para reiniciar\n\r");
                        while(texto==0) {
                            slider = tsi.readPercentage();

                            if(slider>0 && slider<0.4) {
                                me_simon_estado=E_reinicio;
                                printf("\nPreparate...\n\r");
                                printf("Toca el slider cuando estes listo\n\r");
                                texto=1;
                            }
                        }
                        break;

                    case E_reinicio:

                        /*salidas*/
                        reset_leds();

                        memoria=0;
                        final=0;
                        tmo=0;
                        tmoant=1;

                        seleccion=0;
                        correctas=0;
                        incorrectas=0;
                        sliderant=0;
                        seleccionant=0;
                        resultado=0;

                        /*transición*/
                        slider = tsi.readPercentage();
                        if(slider!=0) {
                            printf("\nCOMIENZA\n\r");
                            me_simon_estado=E_random;
                            while(slider!=0)
                                slider = tsi.readPercentage();
                        }
                        break;
                    }
                }
            }
    }
}
