/* mbed Example Program
 * Copyright (c) 2006-2014 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX); // tx, rx

/* W7500
LED1 = LED_RED   = LEDR = PC_8
LED2 = LED_GREEN = LEDG = PC_9
LED3 = LED_BLUE  = LEDB = PC_5
LED4 = LED_BLUE
*/
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);
#endif

Ticker toggle_led_ticker;

int j = 1;

void toggle_led() 
{
    ++j;
    if(j == 7) j = 1;
}

// Finite State Machines & Micro­Controllers
// http://www.allaboutcircuits.com/technical-articles/finite-state-machines-microcontrollers/
#define _ERROR_   -1
#define _START_    0
#define _INIT_     1
#define _RUNNING_  2
#define _STOP_     3

#define LED_ON   0
#define LED_OFF  1

int state;
int i;

void start_code(void)
{
 pc.printf("\n\rStart Code %d\n\r", state);
 
 for(i=0; i<300; i++) 
 {
  red = LED_OFF;
  green = LED_OFF;
  blue = LED_OFF;
    wait(0.1);
  red = LED_OFF;
  green = LED_OFF;
  blue = LED_ON;
 }
 wait(2.0);
 state = _INIT_;   
}

void init_code(void)
{
 pc.printf("init Code %d\n\r", state);
 red = LED_OFF;
 green = LED_ON;
 blue = LED_OFF;
 wait(3.0);
 state = _RUNNING_;    
}

void running_code(void)
{
 pc.printf("Running Code %d\n\r", state);
 red = LED_ON;
 green = LED_ON;
 blue = LED_ON;
 wait(10.0);

 for(i=1; i<100; i++) 
 {
    red = j & 1;
    blue = j & 2;
    green = j & 4;
    wait(0.1);
 }
 
 red = LED_ON;
 green = LED_ON;
 blue = LED_ON;
 wait(10.0);
 
 state = _STOP_;
}

void stop_code(void)
{
 pc.printf("Stop Code %d\n\r", state);
 red = LED_OFF;
 green = LED_OFF;
 blue = LED_OFF;
 wait(2.0);
 state = _ERROR_; // mise en erreur pour test
}

void error_code(void)
{
 pc.printf("Error Code %d\n\r", state);
 red = LED_ON;
 green = LED_OFF;
 blue = LED_OFF;
 wait(15.0);
 red = LED_OFF;
 green = LED_OFF;
 blue = LED_OFF;
 state = _START_;   
}

int main() 
{
 // Serial port configuration (valeurs par defaut) : 9600 baud, 8-bit data, no parity, stop bit
 pc.baud(9600);
 pc.format(8, SerialBase::None, 1);
 
    pc.printf("\n\rHello World!\n\r");
    
    state = _ERROR_;
    
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.25);  
  //------------- 
    while(true) 
    { 
     switch(state)
     {
      case _START_:
      start_code();
      break;
      
      case _INIT_:
      init_code();
      break;
      
      case _RUNNING_:
      running_code();
      break;
      
      case _STOP_:
      stop_code();
      break;
      
      case _ERROR_:
      error_code();
      break;
      
      default:   
      start_code();  
     }
     // Do other things...  
    }
    //--------------
}