#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

// https://developer.mbed.org/users/chris/notebook/Getting-best-ADC-performance/
// https://developer.mbed.org/users/chris/code/ADCPerformanceMeter/

#if defined(TARGET_WIZwiki_W7500)
Serial uart(USBTX, USBRX);
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500
#include "static_colors.h"
// LED RED   : server listning status
// LED GREEN : socket connecting status Ok
// LED BLUE  : socket connecting status Busy
#endif

#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

// Initialize a pins to perform analog input and digital output fucntions
AnalogIn   ain0(A0);

#define NUM_SAMPLES 500000 // size of sample series
#define SAMPLE_BLOCKS 5
 
Timer t;

Ticker ledTick;

char *pch;
char ext[5];

int pos_ext;
int extLen;

//---------------------------
int samples = 0;
int num_4     = 0;
int num_8     = 0;
int num_16    = 0;
int num_32    = 0;
int num_64    = 0;
int num_128   = 0;
int num_256   = 0;
int num_512   = 0;
int num_1024  = 0;
int num_spike = 0; 
   
float AVERAGE = 0.5;
float AVERAGE_MOY = 0.5;
float average_min = 0.0;
float average_max = 3.3;
float average_error = 3.0303;  // Par défaut : 3.0303% sur la valeur centrale 1.65V

#define __AVERAGE_AUTO__    1
        
void PerformanceMeter(void)
{
 float r = 0.0;
 //---------------------------------
 // Take the average over 500,000 samples
 // This is because the bias to 1.65v has a tolerance
 // adjust the analog input to 1.65V, if NO AUTO MODE
 
 uart.printf("Taking an average over %d samples\r\n",NUM_SAMPLES);
 
 if( __AVERAGE_AUTO__ ) 
 {
     COLOR(_BLUE_);
     samples = 0;
     average_error = 5.0; // 5% initiale
     uart.printf("AVERAGE AUTO : error %f%%\r\n", average_error);
     
     while(samples < NUM_SAMPLES)
     {
      r = ain0.read();
 
            AVERAGE_MOY += r;
            samples++;
     }
     
     AVERAGE_MOY /= NUM_SAMPLES;
     average_min = AVERAGE_MOY - (AVERAGE_MOY * average_error / 100.0);
     average_max = AVERAGE_MOY + (AVERAGE_MOY * average_error / 100.0);
     uart.printf("Average Moyenne (for 5%%) = %f , Min = %f , Max = %f\r\n",3.3 * AVERAGE, 3.3 * average_min, 3.3 * average_max);
     samples = 0;
     
     while(samples < NUM_SAMPLES) 
     {
        r = ain0.read();
 
        if((r > average_min) && (r < average_max))
        {
            AVERAGE += r;
            samples++;
        }
     }
    
    AVERAGE /= NUM_SAMPLES;
    average_min = AVERAGE - (AVERAGE * average_error / 100.0);
    average_max = AVERAGE + (AVERAGE * average_error / 100.0);
    uart.printf("Average (for 5%%) = %f , Min = %f , Max = %f\r\n",3.3 * AVERAGE, 3.3 * average_min, 3.3 * average_max);
    // étalonage à 1% --------------------
    average_error = 1.0; // 1%
    COLOR(_YELLOW_);
    samples = 0;
    
    while(samples < NUM_SAMPLES) 
    {
        r = ain0.read();
 
        if((r > average_min) && (r < average_max))
        {
            AVERAGE += r;
            samples++;
        }
    }
    
    AVERAGE /= NUM_SAMPLES;
    average_min = AVERAGE - (AVERAGE * average_error / 100.0);
    average_max = AVERAGE + (AVERAGE * average_error / 100.0);
    uart.printf("Average (for 1%%) = %f , Min = %f , Max = %f\r\n",3.3 * AVERAGE, 3.3 * average_min, 3.3 * average_max); 
 }
 else
 {
  COLOR(_PURPLE_);
  average_min = 1.65 - (1.65 * average_error / 100.0); // 0.45 --> -3,0303% of 1.65V --> 1.485V
  average_max = 1.65 + (1.65 * average_error / 100.0); // 0.55 --> +3,0303% of 1.65V --> 1.815V
  samples = 0;
  
  while(samples < NUM_SAMPLES) 
    {
        r = ain0.read();
 
        if((r > average_min) && (r < average_max))  // 0.7425V à 0.9075
        {
            AVERAGE += r;
            samples++;
        }
    }
 
    AVERAGE /= NUM_SAMPLES;
    uart.printf("Average = %f , Min = %f , Max = %f\r\n",3.3 * AVERAGE, 3.3 * average_min, 3.3 * average_max);
 }
 
   samples = 0;  
    
    // Now start sampling series of 500,000
    // acculumating the errors seen in each range
    uart.printf("Profiling %d samples\r\n",SAMPLE_BLOCKS*NUM_SAMPLES);
    float a;
    
    for(int j=0; j < SAMPLE_BLOCKS ; j++) 
    {
        t.reset();
        t.start();
        COLOR(_WHITE_);
        //uart.printf("%d SAMPLE BLOCKS\r\n",j);
        
        for(int i = 0; i < NUM_SAMPLES ; i++) 
        {
            a = ain0.read();
 
            if(a == 1.0) {
                num_spike++;    // > 2048 lsb
            } else if (a > (AVERAGE + 0.2500)) {
                num_1024++;    // > 1024 lsb
            } else if (a > (AVERAGE + 0.0625)) {
                num_512++;    // > 512 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_256++;    // > 256 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_128++;    // > 128 lsb
            } else if (a > (AVERAGE + 0.0156)) {
                num_64++;    // > 64 lsb
            } else if (a > (AVERAGE + 0.0078)) {
                num_32++;    // > 32 lsb
            } else if (a > (AVERAGE + 0.0039)) {
                num_16++;    // > 16 lsb
            } else if (a > (AVERAGE + 0.0019)) {
                num_8++;    // > 8 lsb
            } else if (a > (AVERAGE + 0.0009)) {
                num_4++;    // > 8 lsb
            }
 
            samples++;
        }
        t.stop();
        COLOR(_BLACK_);
        if(j==0)
        {
            uart.printf("Samples\t");
            uart.printf("4\t");
            uart.printf("8\t");
            uart.printf("16\t");
            uart.printf("32\t");
            uart.printf("64\t");
            uart.printf("128\t");
            uart.printf("256\t");
            uart.printf("512\t");
            uart.printf("1024\t");
            uart.printf("Spikes\t");
            uart.printf("Time\r\n");
        }
        
        // Every 500,000 print the results
        uart.printf("%d\t",samples);
        uart.printf("%d\t",num_4);
        uart.printf("%d\t",num_8);
        uart.printf("%d\t",num_16);
        uart.printf("%d\t",num_32);
        uart.printf("%d\t",num_64);
        uart.printf("%d\t",num_128);
        uart.printf("%d\t",num_256);
        uart.printf("%d\t",num_512);
        uart.printf("%d\t",num_1024);
        uart.printf("%d\t",num_spike);
        uart.printf("%fs\r\n",t.read());
    }
 
    uart.printf("==== Test Complete ====\r\n");
    COLOR(_GREEN_);
    //------------------------------- 
    // TEST continu
    uart.printf("==== Test Continu avec %d Samples ====\r\n", NUM_SAMPLES / 10);
    samples = 0;
    
    while(1) 
    {
            a = ain0.read();
            samples++;
            
            if(a == 1.0) {
                num_spike++;    // > 2048 lsb
            } else if (a > (AVERAGE + 0.2500)) {
                num_1024++;    // > 1024 lsb
            } else if (a > (AVERAGE + 0.0625)) {
                num_512++;    // > 512 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_256++;    // > 256 lsb
            } else if (a > (AVERAGE + 0.0312)) {
                num_128++;    // > 128 lsb
            } else if (a > (AVERAGE + 0.0156)) {
                num_64++;    // > 64 lsb
            } else if (a > (AVERAGE + 0.0078)) {
                num_32++;    // > 32 lsb
            } else if (a > (AVERAGE + 0.0039)) {
                num_16++;    // > 16 lsb
            } else if (a > (AVERAGE + 0.0019)) {
                num_8++;    // > 8 lsb
            } else if (a > (AVERAGE + 0.0009)) {
                num_4++;    // > 8 lsb
            }
            
        if(samples == NUM_SAMPLES / 10)
        {
         uart.printf("Samples\t");
         uart.printf("4\t");
         uart.printf("8\t");
         uart.printf("16\t");
         uart.printf("32\t");
         uart.printf("64\t");
         uart.printf("128\t");
         uart.printf("256\t");
         uart.printf("512\t");
         uart.printf("1024\t");
         uart.printf("Spikes\r\n");
         // Every 500,000 print the results
         uart.printf("%d\t",samples);
         uart.printf("%d\t",num_4);
         uart.printf("%d\t",num_8);
         uart.printf("%d\t",num_16);
         uart.printf("%d\t",num_32);
         uart.printf("%d\t",num_64);
         uart.printf("%d\t",num_128);
         uart.printf("%d\t",num_256);
         uart.printf("%d\t",num_512);
         uart.printf("%d\t",num_1024);
         uart.printf("%d\r\n\r\n",num_spike);
         num_4 = 0;
         num_8 = 0;
         num_16 = 0;
         num_32 = 0;
         num_64 = 0;
         num_128 = 0;
         num_256 = 0;
         num_512 = 0;
         num_1024 = 0;
         num_spike = 0;
         samples = 0;
        }
    } 
}

//--------------------------------------------

int main(void)
{
 // initialisation des variables

    
 //--------------
 COLOR(_BLACK_);
 // Serial Interface eth;
 // Serial port configuration (valeurs par defaut) : 9600 baud, 8-bit data, no parity, stop bit
 uart.baud(9600);
 uart.format(8, SerialBase::None, 1);
 COLOR(_RED_);
 uart.printf("WIZwiki-W7500 - mBED ( Compiled at : %s and %s )\r\n",  __DATE__ , __TIME__);
 uart.printf("Initializing\n\r");
 wait(1.0);
   
 PerformanceMeter();
}
