#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <math.h>
#include <stdio.h>
#include <string.h>

#define NB_SAMPLES    10
unsigned long int Sample = 0;
float adc_samples[NB_SAMPLES];// = { 0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0,1.01,1.02,1.03,1.04 };
float time_samples[NB_SAMPLES];// = { -0.1,2,3,4,5,6,7,8,9,10,11,12,13,14 };
float x_min = 0.0, x_max = 0.0;
float y_min = 0.0, y_max = 0.0;
float Seconds = 0.0;
float meas = 0.0;

#define USE_DHCP    1
/*
MAC Address Details ( http://www.macvendorlookup.com/ )
Company Wiznet Address
Seoul 135-830
Nonyhun, Kangnam
KOREA, REPUBLIC OF
Range : 00:08:DC:00:00:00 - 00:08:DC:FF:FF:FF
Type : MA-L: IEEE MAC Address Large (24-bit block size)

*/
//#define MAC     "\x31\x41\x59\x26\x53\x58"
#define MAC     "\x00\x08\xDC\x31\x41\x59"
//#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.0.170"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.0.254"

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

#if defined(TARGET_WIZwiki_W7500)
Serial uart(USBTX, USBRX);
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500
#include "static_colors.h"
// LED RED   : server listning status
// LED GREEN : socket connecting status Ok
// LED BLUE  : socket connecting status Busy
#endif

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

//------ THING_SPEAK ------------------

#define THRESHOLD_V   0.01
float adc_v = 0.0;
float adc_v_moy = 0.0;
float adc_v_moy_old = 0.0;
int ret;
bool status;
float calcule_update_time;
#define UPDATE_TIME_THING_SPEAK   15.0

char paq_en[64];
#define THING_SPEAK_IP_STR      "184.106.153.149" /* thingspeak.com IP Address */
#define THING_SPEAK_IP_PORT     80 /* port number */
#define THING_SPEAK_KEY_STR     "PD6JY2N94E3N0UNO" /* API key */
#define THING_SPEAK_CHANNEL     132986 /* channel ID */
#define THING_SPEAK_LABEL_STR   "field1"
char * str0 = "POST /update HTTP/1.1\n";
char * str1 = "Host: api.thingspeak.com\n";
char * str2 = "Connection: close\n";
char * str3 = "X-THINGSPEAKAPIKEY: ";
char * str4 = "Content-Type: application/x-www-form-urlencoded\n";
char * write_key = "PD6JY2N94E3N0UNO";
char * str5 = "Content-Length: ";
TCPSocketConnection client_th;

void thingspeak_update(void)
{
  int attempt = 0;
  int length;
  char buffer_th[64];
  char data_entry[64]; 
  
 // active l'envoi sur THING SPEAK si l'évolution moyenne est supérieure au seuil désiré
 if((abs(adc_v_moy - adc_v_moy_old) >= THRESHOLD_V))
 {
  while(attempt < 4)
   { 
    uart.printf("\n\rWaiting for connection to ThingSpeak server...\n\r");    
    ret = client_th.connect(THING_SPEAK_IP_STR,THING_SPEAK_IP_PORT);
    
    if(!ret) 
    {
     uart.printf("Connected to ThingSpeak server\n\r");
    }
    else 
    {
     uart.printf("Connection attempt to ThingSpeak server failed\n\r");
     attempt++;
    } 
    
    if(client_th.is_connected() ) // try to send data
    { 
     // METHODE POST
     
     // update function
     // POST /update HTTP/1.1\n
     client_th.send(str0,strlen(str0));
     uart.printf("%s >%d\n\r",str0,strlen(str0));
     // Host: api.thingspeak.com\n
     client_th.send(str1,strlen(str1));
     uart.printf("%s >%d\n\r",str1,strlen(str1));
     // Connection: close\n
     client_th.send(str2,strlen(str2));
     uart.printf("%s >%d\n\r",str2,strlen(str2));
     // X-THINGSPEAKAPIKEY: PD6JY2N94E3N0UNO
     sprintf(buffer_th,"%s %s\n",str3,write_key);
     client_th.send(buffer_th,strlen(buffer_th));
     uart.printf("%s >%d",buffer_th,strlen(buffer_th));
     // Content-Type: application/x-www-form-urlencoded\n
     client_th.send(str4,strlen(str4));
     uart.printf("%s >%d",str4,strlen(str4));
     
     sprintf(data_entry,"field1=%f\n",adc_v_moy ); //adc moyenne en volts
     length=strlen(data_entry);
     // Content-Length: 
     sprintf(buffer_th,"Content-Length: %d\n\n",length);
     uart.printf("%s >%d\n\r",buffer_th,strlen(buffer_th));
     
     uart.printf("%s >%d\n\r",data_entry,strlen(data_entry));
     client_th.send(buffer_th,strlen(buffer_th));
     client_th.send(data_entry,strlen(data_entry));
     
     // METHODE GET
     // http://api.thingspeak.com/update?api_key=PD6JY2N94E3N0UNO&field1=value
    
     attempt = 4;
    }   
   }  
  
  adc_v_moy_old = adc_v_moy;
 }
}

//------ THING_SPEAK ------------------


char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

// Initialize a pins to perform analog input and digital output fucntions
AnalogIn   ain0(A0);
AnalogIn   ain1(A1);
AnalogIn   ain2(A2);
AnalogIn   ain3(A3);

float a0_f, a1_f, a2_f, a3_f;

#define __IP_LOCAL__           IP
#define  __hebergement__                  "http://olivier.fournet.free.fr/"
#define  __Time_between_page_refresh__    "1"

int refresh = 1; // 1 second refresh

//------------
#define      __Time_tic_in_Second__      0.1

Ticker time_tic;

void add_one_tic()
{       
 int i;
 
 Seconds = Seconds + (float)__Time_tic_in_Second__;
 
 // mesures ADC
    meas = ain0.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    // valeur instantanée pour Thing Speak   
    adc_v = meas * 3.3;
    meas = meas * 3300.0; // Change the value to be in the 0 to 3300 range
    // moyenne sur 10 valeurs
    adc_v_moy = 0.1 * (9.0 * adc_v_moy + adc_v);
 
    x_min = x_max = Seconds;
    y_min = y_max = meas;
                    
    for(i = 1 ; i < NB_SAMPLES ; i++)
    {
     time_samples[i-1] = time_samples[i];
     adc_samples[i-1] = adc_samples[i];
     if( time_samples[i] < x_min ) x_min = time_samples[i];
     if( time_samples[i] > x_max ) x_max = time_samples[i];
     if( adc_samples[i] < y_min ) y_min = adc_samples[i];
     if( adc_samples[i] > y_max ) y_max = adc_samples[i];
    }

    adc_samples[NB_SAMPLES-1] = meas;
    time_samples[NB_SAMPLES-1] = Seconds;
}
//------------

Ticker ledTick;

char *pch;
char ext[5];
char ext_gif[] = "gif";
char ext_jpg[] = "jpg";
char ext_png[] = "png";
char ext_tiff[] = "tiff";
int pos_ext;
int extLen;

void ledTickfunc()
{
    led_r = !led_r;
}
    
void printf_send_client(const char *str_c)
{
 char http_send[HTTPD_MAX_REQ_LENGTH+1];   
 sprintf(http_send,str_c);
 client.send(http_send,strlen(http_send));
}

void variables(void)
{
 printf_send_client("<SCRIPT script language=\"javascript\" type=\"text/javascript\">\r\n");
 
 a0_f = ain0.read()*3.3;
 sprintf(httpHeader,"A0 = %3.3f;\r\n", a0_f);
 client.send(httpHeader,strlen(httpHeader));
 
 a1_f = ain1.read()*3.3;
 sprintf(httpHeader,"A1 = %3.3f;\r\n", a1_f);
 client.send(httpHeader,strlen(httpHeader));
 
 a2_f = ain2.read()*3.3;
 sprintf(httpHeader,"A2 = %3.3f;\r\n", a2_f);
 client.send(httpHeader,strlen(httpHeader));
 
 a3_f = ain3.read()*3.3;
 sprintf(httpHeader,"A3 = %3.3f;\r\n", a3_f);
 client.send(httpHeader,strlen(httpHeader));
 
 printf_send_client("</SCRIPT>\r\n"); 
}


void ETAT(void)
{
  int i;
  
  // httpHeader
  printf_send_client("HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            
  // Début page Web
  printf_send_client("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\r\n");

  // meta_refresh
  sprintf(httpHeader,"<meta http-equiv=\"refresh\" content=\"" __Time_between_page_refresh__ ";url=http://%s/\">\r\n", eth.getIPAddress() );
  //sprintf(httpHeader,"<meta http-equiv=\"refresh\" content=\"1;url=http://%s/\">\r\n", eth.getIPAddress() );
  //sprintf(httpHeader,"<meta http-equiv=\"refresh\" content=\"%u;url=http://%s/\">\r\n", refresh, eth.getIPAddress() );
  client.send(httpHeader,strlen(httpHeader));
  
  printf_send_client("<html><head>\r\n");
  // title
  printf_send_client("<title>WIZwiki-W7500 - Flot Examples: Interactivity</title>\r\n");
  printf_send_client("<LINK REL=\"SHORTCUT ICON\" type=\"image/x-icon\" href=\"" __hebergement__ "favicon.ico\">\r\n<link rel=\"icon\" href=\"" __hebergement__ "favicon.ico\" type=\"image/x-icon\">\r\n");
  // JavaScript Interactivity  
  sprintf(httpHeader,"<script language=\"javascript\" type=\"text/javascript\" src=\"" __hebergement__ "electronique/e/WIZwiki-W7500/js/WIZwiki-W7500_Interactivity_init.js\"></script>\r\n");
  client.send(httpHeader,strlen(httpHeader));
  
  printf_send_client("<script language=\"javascript\" type=\"text/javascript\">init_WIZwiki_W7500_Interactivity();</script>\r\n");
  
  // Variables JavaScript
  printf_send_client("<script language=\"javascript\" type=\"text/javascript\">\r\n");
  printf_send_client("var color_Y = \"#FF0000\";\r\n");
  printf_send_client("var label_Y = \"Adc(mV)\";\r\n");
  // sprintf(httpHeader, "var x_min = -0.5, x_max =  14.5, y_min = -0.5, y_max =  1.5;\r\n"); // TEST
  sprintf(httpHeader, "var x_min = %.1f, x_max = %.1f, y_min = %.1f, y_max = %.1f;\r\n", x_min, x_max, y_min, y_max);
  client.send(httpHeader,strlen(httpHeader));
  
  // sprintf(httpHeader, "var array_value = [[-0.1,0.1],[2,0.2],[3,0.3],[4,0.4],[5,0.5],[6,0.6],[7,0.7],[8,0.8],[9,0.9],[10,1],[11,1.01],[12,1.02],[13,1.03],[14,1.04]];\r\n"); // TEST
  // client.send(httpHeader,strlen(httpHeader));  // TEST
  
  if(Sample > NB_SAMPLES)
    {
     printf_send_client("var array_value = [");

     for(i = 0 ; i < NB_SAMPLES ; i++)
     {
      if(i < NB_SAMPLES) sprintf(httpHeader, "[%.1f,%.1f],", time_samples[i], adc_samples[i]);
      else sprintf(httpHeader, "[%.1f,%.1f]", time_samples[i], adc_samples[i]);
      client.send(httpHeader,strlen(httpHeader));
     }
     printf_send_client("];\r\n");
    }
    
    Sample++;
    printf_send_client("</script>\r\n");
    
    // <SCRIPT>
    variables();
    // <FIN SCRIPT>
    // Fin Variable JavaScript
    printf_send_client("</head><body><center>\r\n");
            
  sprintf(httpHeader,"<h2>WIZwiki-W7500 - mBED</h2> ( Compiled at : %s and %s )<p>\r\n",  __DATE__ , __TIME__);
  client.send(httpHeader,strlen(httpHeader));
  
  printf_send_client("<p>(<a href=\"http://www.flotcharts.org/flot/examples/interacting/index.html\">Flot Examples: Interactivity</a>)<p>\r\n");
  
  printf_send_client("ETAT :<p>\r\n");
  
  sprintf(httpHeader,"IP: %s, MASK: %s, GW: %s<p>\r\n",
                      eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
  client.send(httpHeader,strlen(httpHeader));
  
  //sprintf(httpHeader,"&tilde;A0 :<script>document.write(A0);</script>V<br>\r\n");
  sprintf(httpHeader,"&tilde;A0 : %3.3fV<br>\r\n", a0_f);
  client.send(httpHeader,strlen(httpHeader));
            
  //sprintf(httpHeader,"&tilde;A1 :<script>document.write(A1);</script>V<br>\r\n");
  sprintf(httpHeader,"&tilde;A1 : %3.3fV<br>\r\n", a1_f);
  client.send(httpHeader,strlen(httpHeader));
            
  //sprintf(httpHeader,"&tilde;A2 :<script>document.write(A2);</script>V<br>\r\n");
  sprintf(httpHeader,"&tilde;A2 : %3.3fV<br>\r\n", a2_f);
  client.send(httpHeader,strlen(httpHeader));
            
  //sprintf(httpHeader,"&tilde;A3 :<script>document.write(A3);</script>V<p>\r\n");
  sprintf(httpHeader,"&tilde;A3 : %3.3fV<br>\r\n", a3_f);
  client.send(httpHeader,strlen(httpHeader));
  
  sprintf(httpHeader, "Time : %.1f Seconds - Sample : %u<p>\r\n", Seconds, Sample);// diplays the human readable Seconds
  client.send(httpHeader,strlen(httpHeader));
  
  printf_send_client("<p><script language=\"javascript\" type=\"text/javascript\">WIZwiki_W7500_Interactivity();</script><p>\r\n");
  
  printf_send_client("<p><a href=\"..\">Root</a>\r\n");
  
  printf_send_client("</center></body></html>\r\n");              
}

//--------------------------------------------
void Serial_Interface_init(void)
{
 // Serial Interface eth;
    // Serial port configuration (valeurs par defaut) : 9600 baud, 8-bit data, no parity, stop bit
    uart.baud(9600);
    uart.format(8, SerialBase::None, 1);
    uart.printf("Initializing\n");
  wait(1.0);   
}

void Check_File_System(void)
{
 //    Check File System
 uart.printf("Checking File System\n");
 DIR *d = opendir("/sd/");
 if(d != NULL) 
 {
  uart.printf("SD Card Present\n");
 } 
 else 
 {
  uart.printf("SD Card Root Directory Not Found\n");
 }
 wait(1.0);   
}

void ethernet_init(void)
{
 //    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    #if USE_DHCP
    //eth.init Use DHCP
    int ret = eth.init((uint8_t*)MAC);    // Use DHCP for WIZnetInterface
    uart.printf("Connecting DHCP\n");
    #else
    int ret = eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    uart.printf("Connecting (IP,mask,Gateway)\n");
    #endif
    wait(1.0);
    // Check Ethernet Link-Done
    uart.printf("Check Ethernet Link\r\n");
    
    if(eth.link() == true) 
    { 
     uart.printf("- Ethernet PHY Link - Done\r\n");
     COLOR(_RED_);
    }
    else 
    {
     uart.printf("- Ethernet PHY Link - Fail\r\n");
     COLOR(_BLACK_);
    }
    wait(1.0);
    if(!ret) 
    {
     uart.printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
     ret = eth.connect();
     
     if(!ret) 
     {
            uart.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
      COLOR(_CYAN_);
     } 
     else 
     {
            uart.printf("Error ethernet.connect() - ret = %d\r\n", ret);
      COLOR(_BLUE_);
      exit(0);
     }
    } 
    else 
    {
        uart.printf("Error ethernet.init() - ret = %d\r\n", ret);
     COLOR(_BLACK_);
     exit(0);
    }  
      
    wait(1.0);
 //    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server Listening\n");   
}

int main(void)
{
    // initialisation des variables
 int i;
 
 for(i = 0 ; i < NB_SAMPLES ; i++)
 {
      time_samples[i] = 0;
      adc_samples[i] = 0.0;
 }
 
 adc_v_moy = ain0.read()*3.3; 
 adc_v_moy_old = adc_v_moy;
 //------------------
 Serial_Interface_init();
 
 // Init the ticker with the address of the function (add_one_second) to be attached and the interval (1000 ms)
 time_tic.attach(&add_one_tic, __Time_tic_in_Second__);
 //--------------
    ledTick.attach(&ledTickfunc,0.5);
    //---------------
  Check_File_System();  
  ethernet_init();
  
    while(true) 
    {
        uart.printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        uart.printf("Connection from: %s\r\n", client.get_address());
        while(true) 
        {
            //led_g = LED_ON;
            COLOR(_GREEN_);
            int n = client.receive(buffer, sizeof(buffer));
            if(n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if(n >= 1024) 
            {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } 
            else 
            {
                buffer[n]=0;
            }
            if(!strncmp(buffer, "GET ", 4)) 
            {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if(eou == NULL) 
                {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } 
                else 
                {
                    *eou = 0;
                    //get_file(uristr);
                    ETAT();
                    thingspeak_update();
                }
            }
        }
        //led_g = LED_OFF;
        COLOR(_BLACK_);
        client.close();
        client_th.close();
        //
    }
}
