#if defined(TARGET_WIZwiki_W7500)
/* W7500
LED1 = LED_RED   = LEDR = PC_8
LED2 = LED_GREEN = LEDG = PC_9
LED3 = LED_BLUE  = LEDB = PC_5
LED4 = LED_BLUE
*/
DigitalOut led_r(LED_RED);
DigitalOut led_g(LED_GREEN);
DigitalOut led_b(LED_BLUE);

#define LED_ON   0
#define LED_OFF  1

#define _WHITE_   9
#define _PURPLE_  7
#define _BLUE_    6
#define _CYAN_    55
#define _GREEN_   5
#define _YELLOW_  4
//#define _ORANGE_  3
#define _RED_     2
#define _BLACK_   0

void COLOR(int c)
{
 switch(c)
 {
  case _WHITE_:
  led_r = LED_ON, led_g = LED_ON, led_b = LED_ON;
  break;
  
  case _PURPLE_:
  led_r = LED_ON, led_g = LED_OFF, led_b = LED_ON;
  break;
  
  case _BLUE_:
  led_r = LED_OFF, led_g = LED_OFF, led_b = LED_ON;
  break;
  
  case _CYAN_:
  led_r = LED_OFF, led_g = LED_ON, led_b = LED_ON;
  break;
  
  case _GREEN_:
  led_r = LED_OFF, led_g = LED_ON, led_b = LED_OFF;
  break;
  
  case _YELLOW_:
  led_r = LED_ON, led_g = LED_ON, led_b = LED_OFF;
  break;

  case _RED_:
  led_r = LED_ON, led_g = LED_OFF, led_b = LED_OFF;
  break;
  
  case _BLACK_:
  default:
  led_r = LED_OFF, led_g = LED_OFF, led_b = LED_OFF;  
 }   
}
#endif