#include "mbed.h"

/* W7500
LED1 = LED_RED   = LEDR = PC_8
LED2 = LED_GREEN = LEDG = PC_9
LED3 = LED_BLUE  = LEDB = PC_5
LED4 = LED_BLUE
*/

DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);

Ticker toggle_led_ticker;

int i = 1;

void toggle_led() 
{
    red = i & 1;
    blue = i & 2;
    green = i & 4;
    ++i;
    if(i == 7) i = 1;
}

int main() 
{
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.5);
    
    while(true) 
    { 
     // Do other things...  
    }
}