#include "mbed.h"
#if defined(TARGET_WIZwiki_W7500)
Serial pc(USBTX, USBRX); // tx, rx
/* W7500
LED1 = LED_RED   = LEDR = PC_8
LED2 = LED_GREEN = LEDG = PC_9
LED3 = LED_BLUE  = LEDB = PC_5
LED4 = LED_BLUE
*/
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);
#endif

#define LED_ON   0
#define LED_OFF  1

#define _WHITE_   0xFFFFFF //9
#define _PURPLE_  0xFF00FF //7
#define _BLUE_    0x0000FF //6
#define _CYAN_    0x00FFFF //55
#define _GREEN_   0x00FF00 //5
#define _YELLOW_  0xFFFF00 //4
#define _ORANGE_  0x10FF00 //3
#define _RED_     0xFF0000 //2
#define _BLACK_   0x000000 //0

Ticker RGB_led_ticker;

int j_color = 0;
int r_value = 0;
int g_value = 0;
int b_value = 0;

void RGB_led() 
{
    ++j_color;
    if(j_color >= 256) j_color = 0;
    
    if(r_value <= j_color) red = LED_ON;
    else red = LED_OFF;
    
    if(g_value <= j_color) green = LED_ON;
    else green = LED_OFF;
    
    if(b_value <= j_color) blue = LED_ON;
    else blue = LED_OFF;
}

void RGB_COLOR(int r, int g, int b)
{
 r_value = 255 - r;
 g_value = 255 - g;
 b_value = 255 - b;
 /*
 if(r_value<0)   r = 0;
 if(r_value>255) r = 255;
 
 if(g_value<0)   g = 0;
 if(g_value>255) g = 255;
 
 if(b_value<0)   b = 0;
 if(b_value>255) b = 255;
 */
}

void init_rgb_color(void)
{
  RGB_led_ticker.attach(&RGB_led, 0.01);  
}

void COLOR(int c)
{
 switch(c)
 {
  case _WHITE_:
  //red = LED_ON, green = LED_ON, blue = LED_ON;
  RGB_COLOR(255, 255, 255);
  break;
  
  case _PURPLE_:
  //red = LED_ON, green = LED_OFF, blue = LED_ON;
  RGB_COLOR(255, 0, 255);
  break;
  
  case _BLUE_:
  //red = LED_OFF, green = LED_OFF, blue = LED_ON;
  RGB_COLOR(0, 0, 255);
  break;
  
  case _CYAN_:
  //red = LED_OFF, green = LED_ON, blue = LED_ON;
  RGB_COLOR(0, 255, 255);
  break;
  
  case _GREEN_:
  //red = LED_OFF, green = LED_ON, blue = LED_OFF;
  RGB_COLOR(0, 255, 0);
  break;
  
  case _YELLOW_:
  //red = LED_ON, green = LED_ON, blue = LED_OFF;
  RGB_COLOR(255, 255, 0);
  break;
  /*
  case _ORANGE_:
  RGB_COLOR(80, 80, 0);
  break;
  */
  case _RED_:
  //red = LED_ON, green = LED_OFF, blue = LED_OFF;
  RGB_COLOR(255, 0, 0);
  break;
  
  case _BLACK_:
  default:
  //red = LED_OFF, green = LED_OFF, blue = LED_OFF; 
  RGB_COLOR(0, 0, 0);  
 }   
}

int i;

int main() 
{
    // Serial port configuration (valeurs par defaut) : 9600 baud, 8-bit data, no parity, stop bit
 pc.baud(9600);
 pc.format(8, SerialBase::None, 1);
 
    pc.printf("\n\rHello World!\n\r");
    init_rgb_color();
    /*
    while(1000) 
    {
        for (i=1; i<7; i++)
        {
            red = i & 1;
            blue = i & 2;
            green = i & 4;
            wait(0.2);
        }
    }
    */
  COLOR(_BLACK_);
  pc.printf("\n\r_BLACK_\n\r");
 wait(5.0);
  COLOR(_RED_);
  pc.printf("\n\r_RED_\n\r");
 wait(5.0);
  /*COLOR(_ORANGE_);
  pc.printf("\n\r_ORANGE_\n\r");*/
 wait(5.0);
  COLOR(_YELLOW_);
  pc.printf("\n\r_YELLOW_\n\r");
 wait(5.0);
  COLOR(_GREEN_);
  pc.printf("\n\r_GREEN_\n\r");
 wait(5.0);
  COLOR(_CYAN_);
  pc.printf("\n\r_CYAN_\n\r");
 wait(5.0);
  COLOR(_BLUE_);
  pc.printf("\n\r_BLUE_\n\r");
 wait(5.0);
  COLOR(_PURPLE_);
  pc.printf("\n\rH_PURPLE_\n\r");
 wait(5.0);
  COLOR(_WHITE_);
  pc.printf("\n\r_WHITE_\n\r");
 wait(5.0);
}