/* In this example LED1 is switched on/off using a web browser connected to this HTTP server.
 * The example is based on the Tuxgraphics Web Switch <http://www.tuxgraphics.org/>.
 * This HTTP server is built around the the ENC28J60 chip
 * driven by the UIPEthernet library <https://github.com/ntruchsess/arduino_uip>
 * ported to mbed.
 */

#include <mbed.h>
#include <UIPEthernet.h>
#include <UIPServer.h>
#include <UIPClient.h>
#include <string>

// PC_5 (connectique Morpho) : Entrée Analogique (0 a 3.3V)

// Carte ENC28J60 : http://www.mikroe.com/add-on-boards/communication/serial-ethernet-proto/
 
// Carte ENC28J60 <--> Nucleo F411RE
// PB_5 (connectique Morpho) : MOSI
// PB_4 (connectique Morpho) : MISO
// PB_3 (connectique Morpho) : SCK
// PB_6 (connectique Morpho) : CS

DigitalOut myled(LED1);
AnalogIn    a_in(PC_5); // PC_5 au lieu de PC_0

using namespace std;

// UIPEthernet is the name of a global instance of UIPEthernetClass.
// Do not change the name! It is used within the UIPEthernet library.
#if defined(TARGET_LPC1768)
UIPEthernetClass UIPEthernet(p11, p12, p13, p8);        // mosi, miso, sck, cs
#elif defined(TARGET_LPC1114)
UIPEthernetClass UIPEthernet(dp2, dp1, dp6, dp25);      // mosi, miso, sck, cs
#elif defined(TARGET_LPC11U68)
UIPEthernetClass UIPEthernet(P0_9, P0_8, P1_29, P0_2);  // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F103RB)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F401RE)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F411RE)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs

// If your board/plaform is not present yet then uncomment the following two lines and replace TARGET_YOUR_BOARD as appropriate.

//#elif defined (TARGET_YOUR_BOARD)
//UIPEthernetClass UIPEthernet(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS);   // mosi, miso, sck, cs

#endif

// Note:
// If it happends that any of the SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS pins collide with LED1 pin
// then either use different SPI port (if available on the board) and change the pin names in the constructor UIPEthernet(...) accordingly
// or instead of using LED1 pin, select a free pin (not used by SPI port) and connect to it an external LED which is connected to a resitor that is connected to the groud.
// In the second case remember to replace LED1 in sw(LED1) constructor (see below).


// MAC number must be unique within the connected network. Modify as appropriate.
const uint8_t    MY_MAC[6] = {0x00,0x01,0x02,0x03,0x04,0x06};

// IP address must be also unique and compatible with your network. Change as appropriate.
const IPAddress  MY_IP(192,168,0,170);
#define  __IP_LOCAL__                     "192.168.0.170"

// In this example we are turning on/off LED1.
DigitalOut       sw(LED1);  // Change LED1 to a pin of your choice. However, make sure that it does not collide with any of the SPI pins already used in the UIPEthernet(...) constructor above!

const string PASSWORD     = "secret";   // change as you like

#include <hebergement.h>
#include <Fct_Web.h>

/*
#define  __hebergement__                  "http://olivier.fournet.free.fr/"
#define  __Time_between_page_refresh__    "1"

const string str_meta_refresh  = "<meta http-equiv=\"refresh\" content=\"" __Time_between_page_refresh__ ";url=http://" __IP_LOCAL__ "/\">";

const string str_JavaScript  = "<script language=\"javascript\" type=\"text/javascript\" src=\"" __hebergement__ "electronique/e/WebServerNucleo/js/WebServerNucleo_Interactivity_init.js\"></script>\r\n";

const string str_Compilation_DATE_AND_TIME = "<p>Compilation avec mBED &agrave; " __TIME__ " le " __DATE__" \r\n"; 

// Logo Test d'image en base64 :
// http://webcodertools.com/imagetobase64converter/Create
// const string str_Logo_image =  "<img alt='' src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAACQkWg2AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAUklEQVQ4T2NggIEGMIBzCTDgSh0cHAjrIcFgiGFoGoCWELYQrgLIgGsg4CtkaTibWNfu378fq2tpHx6EbcAMQ8J6iPU3cpIhbCqaisFpCTwVAwB5lit+0ltbrgAAAABJRU5ErkJggg=='>";
const string str_favicon = "<LINK REL=\"SHORTCUT ICON\" type=\"image/x-icon\" href=\"" __hebergement__ "favicon.ico\">\r\n<link rel=\"icon\" href=\"" __hebergement__ "favicon.ico\" type=\"image/x-icon\">";

#define __image_password_folder__                "password_folder.jpg"
const string str_image_Password_Folder  = "<img alt='' src='" __hebergement__ "jpg/" __image_password_folder__ "'>";

#define __image_301_Moved_Permanently__          "301_moved_permanently.jpg"
const string str_moved_perm   = "<h1>301 Moved Permanently <img alt='' src='" __hebergement__ "jpg/" __image_301_Moved_Permanently__ "'></h1>\r\n";

#define __image_401_Unauthorized__               "401_Unauthorized.png"
const string str_Unauthorized = "<h1>401 Unauthorized <img alt='' src='" __hebergement__ "png/" __image_401_Unauthorized__ "'></h1>\r\n";
*/

#define FREQUENCE_SECTEUR             50
#define NB_SAMPLES_PAR_OSCILLATION    100
#define NB_SAMPLES                    5000   // FREQUENCE_SECTEUR * NB_SAMPLES_PAR_OSCILLATION
#define TIME_SAMPLES_us               200    // 1000000 / NB_SAMPLES
unsigned long int Samples = 0;

float Seconds = 0.0;
float time_between_two_measurement_ADC = 0.0;
float meas, meas_sum, meas_moy, meas_min, meas_max;
float vdc, vdc_min, vdc_max;
float vac, pow2_vac, sum_pow2_vac, veff;

Ticker time_measurement_ADC;

void measurement_ADC()
{

    meas = 3300.0 * a_in.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    //wait_us(10);
    meas_sum += meas;
    if(meas_min > meas) meas_min = meas;
    if(meas_max < meas) meas_max = meas;

    vac = meas - 1650.0; // 0V AC = 3,3V/2
    pow2_vac = vac * vac; // valeur VAC au carré
    sum_pow2_vac += pow2_vac; // somme des valeurs AC au carré

    Samples++;

    if( Samples == NB_SAMPLES ) {
        // VDC
        meas_moy = meas_sum;
        meas_moy /= (float)NB_SAMPLES;
        // VAC
        veff = sum_pow2_vac;
        veff /= (float)NB_SAMPLES;
        veff = sqrt(veff);

        Samples = 0;
        meas_sum = 0.0;
        vdc_min = meas_min, vdc_max = meas_max;
        meas_min = 3300.0 , meas_max = 0.0;
        sum_pow2_vac = 0.0;
    }
}

//------------
#define      __Time_between_refresh_in_Second__      0.1

Ticker second_ticker;

void add_one_second()
{
    Seconds = Seconds + (float)__Time_between_refresh_in_Second__;
}
//------------
//const uint16_t   MY_PORT = 80;      // for HTTP connection
//EthernetServer   myServer = EthernetServer(MY_PORT);

/*
const string HTTP_OK      = "HTTP/1.0 200 OK";
const string MOVED_PERM   = "HTTP/1.0 301 Moved Permanently\r\nLocation: ";
const string UNAUTHORIZED = "HTTP/1.0 401 Unauthorized";
*/
//string       httpHeader;     // HTTP header
//string       httpContent;    // HTTP content


// analyse the url given
// return values: -1 invalid password
//                -2 no command given but password valid
//                -3 just refresh page
//                 0 switch off
//                 1 switch on
//
//                The string passed to this function will look like this:
//                GET /password HTTP/1.....
//                GET /password/ HTTP/1.....
//                GET /password/?sw=1 HTTP/1.....
//                GET /password/?sw=0 HTTP/1.....
/*
int8_t analyse_get_url(string& str)
{
    if(str.substr(5, PASSWORD.size()) != PASSWORD)
        return(-1);

    uint8_t pos = 5 + PASSWORD.size();

    if(str.substr(pos, 1) == " ") return(-2);

    if(str.substr(pos, 1) != "/") return(-1);

    pos++;

    string cmd(str.substr(pos, 5));

    if(cmd == "?sw=0")  return(0);

    if(cmd == "?sw=1")  return(1);

    return(-3);
}
*/
/*
string& moved_perm(uint8_t flag)
{
    if(flag == 1)
        httpContent = "/" +  PASSWORD + "/";
    else
        httpContent = "";
   
    httpContent += str_moved_perm;

    return (httpContent);
}
*/
string& page(uint8_t status)
{
    char buffer[128];
    //char time_stamp[32];

    //-------------
    httpContent = str_DOCTYPE;
    httpContent += str_meta_refresh;
    httpContent += "\r\n<HTML><HEAD>\r\n";
    httpContent += "<title>WEB Server Nucleo F411RE & ENC28J60 - ADC</title>\r\n";
    httpContent += str_favicon;
    httpContent += str_JavaScript;
    httpContent += "</HEAD><BODY>\r\n";
    httpContent += "<center><h2>WEB Server Nucleo F411RE (ADC)</h2>\r\n";
    httpContent += "<p>Designed for STM32F411RE & ENC28J60 (ADC)\r\n";
    httpContent += str_Compilation_DATE_AND_TIME;       
    // httpContent += str_Logo_image ;

    httpContent += "<p></center>\r\n<hr><p>\r\n";

    /*
    httpContent += "Local Time: ";
    time_t seconds = time(NULL)+ 19800; // time(null) gives the GMT time .
    // printf("Time as seconds since January 1, 1970 = %d\n", seconds);
    strftime(time_stamp, 32, "%y %m %d, %H:%M:%Ss", localtime(&seconds));
    // this converts the value in seconds obtained above to human readable format and assigns it to the timestamp
    sprintf(buffer, "%s", time_stamp);// diplays the human readable time
    */
    sprintf(buffer, "%.1f ", Seconds);// diplays the human readable Seconds
    httpContent += buffer;
    httpContent += "Seconds\r\n<hr>\r\n";
    //----------------

    httpContent += "AnalogIn(PC_5) :<p>\r\n";
    sprintf(buffer, "%.0f mV Moy ( sum : %.0f - Samples : %u )\r\n", meas_moy, meas_sum, Samples);
    httpContent += buffer;
    httpContent += "<p>\r\n";
    sprintf(buffer, "DC (0 &agrave; 3,3V) : %.0f mV Min,   %.0f mV Max ,   diff : %.0f mV\r\n", vdc_min, vdc_max, vdc_max - vdc_min);
    httpContent += buffer;
    httpContent += "<p>\r\n";
    sprintf(buffer, "AC (-1,65V &agrave; 1,65V) : %.0f mV eff\r\n", veff);
    httpContent += buffer;
    httpContent += "</BODY></HTML>";
    //-----------
    //wait(1);
    return httpContent;
}

/*
void http_send(EthernetClient& client, string& header, string& content)
{
    char content_length[5] = {};

    header += "\r\nContent-Type: text/html\r\n";
    header += "Content-Length: ";
    sprintf(content_length, "%d", content.length());
    header += string(content_length) + "\r\n";
    header += "Pragma: no-cache\r\n";
    header += "Connection: About to close\r\n";
    header += "\r\n";
    string webpage = header + content;
    client.write((uint8_t*)webpage.c_str(),webpage.length());
}
*/
int main()
{
    meas_moy = 0.0;
    Samples = 0;
    meas_sum = 0.0;
    meas_min = 3300.0 , meas_max = 0.0;
    sum_pow2_vac = 0.0;
    
// RTC
//set_time(1387188323); // Set RTC time to 16 December 2013 10:05:23 UTC

// Date and time are set.

// Init the ticker with the address of the function (add_one_second) to be attached and the interval (1000 ms)
    second_ticker.attach(&add_one_second, __Time_between_refresh_in_Second__);

//-----------------
// 50 Hz --> 20ms
// 100 samples par oscillations = 20 / 100 = 0.2ms = 200µs
// 100 samples * 50 oscillations = 5000 samples au total par secondes
// interval: 200 micro seconds chaques samples
    time_measurement_ADC.attach_us(&measurement_ADC, TIME_SAMPLES_us);

 //-----------------
 HTTP_LOOP();
 /*
    UIPEthernet.begin(MY_MAC,MY_IP);
    myServer.begin();
    while(1) {
        EthernetClient client = myServer.available();
        if(client) {
            size_t size = client.available();
            if(size > 0) {
                uint8_t* buf = (uint8_t*)malloc(size);
                size = client.read(buf, size);
                string received((char*)buf);
                free(buf);
                if(received.substr(0, 3) != "GET") {
                    // head, post or other method
                    // for possible status codes see:
                    // http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
                    httpHeader = HTTP_OK;
                    httpContent = "<h1>200 OK</h1>";
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                if(received.substr(0, 6) == "GET / ") {
                    httpHeader = HTTP_OK;
                    
                    http_send(client, httpHeader, page(sw));
                    continue;
                }

                int cmd = analyse_get_url(received);

                if(cmd == -2) {
                    // redirect to the right base url
                    httpHeader = MOVED_PERM;
                    http_send(client, httpHeader, moved_perm(1));
                    continue;
                }

                if(cmd == -1) {
                    httpHeader = UNAUTHORIZED;
                    
                    httpContent = str_Unauthorized;
                    http_send(client, httpHeader, httpContent);
                    continue;
                }
            }
        }
    }
    */
}


