/* In this example LED1 is switched on/off using a web browser connected to this HTTP server.
 * The example is based on the Tuxgraphics Web Switch <http://www.tuxgraphics.org/>.
 * This HTTP server is built around the the ENC28J60 chip 
 * driven by the UIPEthernet library <https://github.com/ntruchsess/arduino_uip>
 * ported to mbed.
 */

#include <mbed.h>
#include <UIPEthernet.h>
#include <UIPServer.h>
#include <UIPClient.h>
#include <string>

 // Carte ENC28J60 : http://www.mikroe.com/add-on-boards/communication/serial-ethernet-proto/
 
// PC_5 (connectique Morpho) : Entrée Analogique (0 à 3.3V)

// Carte ENC28J60 <--> Nucleo F411RE
// PB_5 (connectique Morpho) : MOSI
// PB_4 (connectique Morpho) : MISO
// PB_3 (connectique Morpho) : SCK
// PB_6 (connectique Morpho) : CS

DigitalOut  myled(LED1);
AnalogIn    a_in(PC_5); // PC_5 au lieu de PC_0
DigitalIn   button_usr(USER_BUTTON);

using namespace std;

// UIPEthernet is the name of a global instance of UIPEthernetClass.
// Do not change the name! It is used within the UIPEthernet library.
#if defined(TARGET_LPC1768)
UIPEthernetClass UIPEthernet(p11, p12, p13, p8);        // mosi, miso, sck, cs
#elif defined(TARGET_LPC1114)
UIPEthernetClass UIPEthernet(dp2, dp1, dp6, dp25);      // mosi, miso, sck, cs
#elif defined(TARGET_LPC11U68)
UIPEthernetClass UIPEthernet(P0_9, P0_8, P1_29, P0_2);  // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F103RB)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F401RE)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs
#elif defined (TARGET_NUCLEO_F411RE)
UIPEthernetClass UIPEthernet(PB_5, PB_4, PB_3, PB_6);   // mosi, miso, sck, cs

// If your board/plaform is not present yet then uncomment the following two lines and replace TARGET_YOUR_BOARD as appropriate.

//#elif defined (TARGET_YOUR_BOARD)
//UIPEthernetClass UIPEthernet(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS);   // mosi, miso, sck, cs

#endif

// Note:
// If it happends that any of the SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS pins collide with LED1 pin
// then either use different SPI port (if available on the board) and change the pin names in the constructor UIPEthernet(...) accordingly
// or instead of using LED1 pin, select a free pin (not used by SPI port) and connect to it an external LED which is connected to a resitor that is connected to the groud.
// In the second case remember to replace LED1 in sw(LED1) constructor (see below).

// MAC number must be unique within the connected network. Modify as appropriate.
const uint8_t    MY_MAC[6] = {0x00,0x01,0x02,0x03,0x04,0x06};

// IP address must be also unique and compatible with your network. Change as appropriate.
const IPAddress  MY_IP(10,0,0,170);
#define  __IP_LOCAL__                     "10.0.0.170"

/* Maison
const IPAddress  MY_IP(192,168,0,170);
#define  __IP_LOCAL__                     "192.168.0.170"
*/
const string PASSWORD     = "secret";   // change as you like

// In this example we are turning on/off LED1.
DigitalOut       sw(LED1);  // Change LED1 to a pin of your choice. However, make sure that it does not collide with any of the SPI pins already used in the UIPEthernet(...) constructor above!

#include <hebergement.h>
#include <Fct_Web.h>

#define NB_SAMPLES    10
unsigned long int Sample = 0;
float adc_samples[NB_SAMPLES];// = { 0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0,1.01,1.02,1.03,1.04 };
float time_samples[NB_SAMPLES];// = { -0.1,2,3,4,5,6,7,8,9,10,11,12,13,14 };
float x_min = 0.0, x_max = 0.0;
float y_min = 0.0, y_max = 0.0;
float Seconds = 0.0;
float meas = 0.0;

//------------
#define      __Time_tic_in_Second__      0.1

Ticker time_tic;

void add_one_tic()
{       
 int i;
 
 Seconds = Seconds + (float)__Time_tic_in_Second__;
 
 // mesures ADC
    meas = a_in.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
    meas = meas * 3300.0; // Change the value to be in the 0 to 3300 range
    
    x_min = x_max = Seconds;
    y_min = y_max = meas;
                    
    for(i = 1 ; i < NB_SAMPLES ; i++)
    {
     time_samples[i-1] = time_samples[i];
     adc_samples[i-1] = adc_samples[i];
     if( time_samples[i] < x_min ) x_min = time_samples[i];
     if( time_samples[i] > x_max ) x_max = time_samples[i];
     if( adc_samples[i] < y_min ) y_min = adc_samples[i];
     if( adc_samples[i] > y_max ) y_max = adc_samples[i];
    }

    adc_samples[NB_SAMPLES-1] = meas;
    time_samples[NB_SAMPLES-1] = Seconds;
}
//------------


string& page(uint8_t status)
{
    char buffer[128];
    int i;
    //char time_stamp[32];

    //-------------
    httpContent = str_DOCTYPE;
    httpContent += str_meta_refresh;
    httpContent += "\r\n<HTML><HEAD>\r\n";
    httpContent += "<title>WEB Server Nucleo F411RE - ENC28J60 - Flot Examples: Interactivity</title>\r\n";
    httpContent += str_favicon;
    httpContent += str_JavaScript;
    httpContent += "<script language=\"javascript\" type=\"text/javascript\">init_WebServerNucleo_Interactivity();</script>\r\n";
    // Variables JavaScript
    httpContent += "<script language=\"javascript\" type=\"text/javascript\">\r\n";
    httpContent += "var color_Y = \"#FF0000\";\r\n";
    httpContent += "var label_Y = \"Adc(x)\";\r\n";
    //httpContent += "var x_min = -0.5, x_max =  14.5, y_min = -0.5, y_max =  1.5;\r\n";
    sprintf(buffer, "var x_min = %.1f, x_max = %.1f, y_min = %.1f, y_max = %.1f;\r\n", x_min, x_max, y_min, y_max);
    httpContent += buffer;
    //httpContent += "var array_value = [[-0.1,0.1],[2,0.2],[3,0.3],[4,0.4],[5,0.5],[6,0.6],[7,0.7],[8,0.8],[9,0.9],[10,1],[11,1.01],[12,1.02],[13,1.03],[14,1.04]];\r\n";
    if(Sample > NB_SAMPLES)
    {
     httpContent += "var array_value = [";
     for(i = 0 ; i < NB_SAMPLES ; i++)
     {
      sprintf(buffer, "[%.1f,%.1f],", time_samples[i], adc_samples[i]);
      httpContent += buffer;
     }
     httpContent += "];\r\n";
    }
    Sample++;
    httpContent += "</script>\r\n";
    // Fin Variable JavaScript
    httpContent += "</HEAD><BODY>\r\n";
    httpContent += "<center><h2>WEB Server Nucleo F411RE</h2>\r\n";
    httpContent += "<p>Designed for STM32F411RE & ENC28J60 (RTC, ADC - <a href=\"http://www.flotcharts.org/flot/examples/interacting/index.html\">Flot Examples: Interactivity</a>),\r\n";
     
    httpContent += str_Compilation_DATE_AND_TIME;       
    // httpContent += str_Logo_image;
    
    httpContent += "<p>\r\n<hr><p>\r\n";
    
    if(status == 1)
    {
        httpContent += "<font color=#00FF00>Switch ON</font> ";
        httpContent += str_ampoule_ON;
        httpContent += "\r\n";
    } 
    else 
    {
        httpContent += "<font color=#FF0000>Switch OFF</font> ";
        httpContent += str_ampoule_OFF;
        httpContent += "\r\n";
    }

    httpContent += "<hr>\r\n";
    //-------------
    httpContent += "USER BUTTON (Contact repos) \r\n";
    if(button_usr)
    {
        httpContent += "<font color=#00FF00>ON</font> ";
        httpContent += str_ampoule_ON;
        httpContent += "\r\n";
    } 
    else 
    {
        httpContent += "<font color=#FF0000>OFF</font> ";
        httpContent += str_ampoule_OFF;
        httpContent += "\r\n";
    }
    
    httpContent += "<hr>\r\n";
    //-------------
    /*
    httpContent += "Local Time: ";
    time_t seconds = time(NULL)+ 19800; // time(null) gives the GMT time .
    // printf("Time as seconds since January 1, 1970 = %d\n", seconds);
    strftime(time_stamp, 32, "%y %m %d, %H:%M:%Ss", localtime(&seconds)); 
    // this converts the value in seconds obtained above to human readable format and assigns it to the timestamp   
    sprintf(buffer, "%s", time_stamp);// diplays the human readable time
    */
    sprintf(buffer, "%.1f Seconds ", Seconds);// diplays the human readable Seconds
    httpContent += buffer;
    httpContent += str_chrono;
    httpContent += "\r\n<hr>\r\n";
    //----------------
    httpContent += "AnalogIn(PC_5) : ";
    sprintf(buffer, "%.0f mV ", meas);
    httpContent += buffer;
    httpContent += str_thermometre;
    httpContent += "<hr>\r\n<p>Usage Password Page : ";
    httpContent += str_password_folder_x64;
    httpContent += "<p>http://host_or_ip/password<p><hr>\r\n";
    httpContent += "<script language=\"javascript\" type=\"text/javascript\">WebServerNucleo_Interactivity();</script>\r\n";
    httpContent += "</center></BODY></HTML>";
    //-----------
    //wait(1);
    return httpContent;
}

int main()
{
 // RTC
 //set_time(1387188323); // Set RTC time to 16 December 2013 10:05:23 UTC
 // Date and time are set.
 
 // initialisation des variables
 int i;
 
 for(i = 0 ; i < NB_SAMPLES ; i++)
 {
      time_samples[i] = 0;
      adc_samples[i] = 0.0;
 }
 // Init the ticker with the address of the function (add_one_second) to be attached and the interval (1000 ms)
 time_tic.attach(&add_one_tic, __Time_tic_in_Second__);
 
 // interval: 200 micro seconds chaques samples
 //time_measurement_ADC.attach_us(&measurement_ADC, TIME_SAMPLES_us);
 
 HTTP_LOOP();
}


