#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#define USE_DHCP    1

#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.0.170"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.0.254"

#define HTTPD_SERVER_PORT   80
#define HTTPD_MAX_REQ_LENGTH   1023
#define HTTPD_MAX_HDR_LENGTH   255
#define HTTPD_MAX_FNAME_LENGTH   127
#define HTTPD_MAX_DNAME_LENGTH   127

#if defined(TARGET_WIZwiki_W7500)
Serial uart(USBTX, USBRX);
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500
#include "static_colors.h"
// LED R     : server listning status
// LED GREEN : socket connecting status Ok
// LED BLUE  : socket connecting status Busy
#endif

EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH+1];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;
char *qrystr;

FILE *fp;
int rdCnt;

// Initialize a pins to perform analog input and digital output fucntions
AnalogIn   ain(A0);

Ticker ledTick;

//char str[] = "This is a sample string";
char *pch;
char ext[5];
char ext_gif[] = "gif";
char ext_jpg[] = "jpg";
char ext_png[] = "png";
char ext_tiff[] = "tiff";
int pos_ext;
int extLen;

void ledTickfunc()
{
    led_r = !led_r;
}

void get_file(char* uri)
{
    int i, ext_j;
    
    uart.printf("get_file %s\n", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if('/' == *lstchr) 
    {
        uart.printf("Open directory /sd%s\n", uri);
        if( 0 == strcmp("/Images/", uri) ) uart.printf("(Directory OK)\n");
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if(d != NULL) 
        {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h2>%s Directory Listing</h2><br><hr><br><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL)
            {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                uart.printf("%s\n", dirName);
                DIR *subDir = opendir(dirName);
                if(subDir != NULL) 
                {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } 
                else 
                {
                    sprintf(httpHeader,"<li><a href=\"./%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        uart.printf("Directory closed\n");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } 
    else 
    {
        sprintf(fileName, "/sd%s", uri);
        fp = fopen(fileName, "r");
        if(fp == NULL)
        {
            uart.printf("File not found\n");
            if( 0 == strcmp("/AIN0.js", uri) )
            {
                uart.printf("(File OK)\n");
                sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: application/javascript\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                
                sprintf(httpHeader,"var AIN0 = %3.3f;\n", ain.read()*3.3f);
                client.send(httpHeader,strlen(httpHeader));
            }
            else
            {
             sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
             client.send(httpHeader,strlen(httpHeader));
             client.send(uri,strlen(uri));
            }
        } 
        else 
        {
         pch = strrchr(fileName,'.');
         
         if( pch != NULL)
         {
          pos_ext = pch - fileName + 1;
          extLen = strlen(fileName) - pos_ext;
         
          uart.printf("Last occurence of '.' found at %d , extLen : %d\n", pos_ext, extLen );
        
          for(i=0; i<extLen; i=i+1)
          {
           ext[i] = fileName[i+pos_ext];   
          }
         
          ext[extLen] = '\0';
         
            uart.printf("Sending header of the : %s\n", fileName);
            uart.printf("extension : %s\n", ext);
            
            if( strcmp(ext, ext_gif) == 0 ) ext_j = 1;
            
            if( strcmp(ext, ext_jpg) == 0 ) ext_j = 2;
            
            if( strcmp(ext, ext_png) == 0 ) ext_j = 3;         
            
            if( strcmp(ext, ext_tiff) == 0 ) ext_j = 4;
          }
          else
          {
             uart.printf("Sending header of the : %s\n", fileName);
             ext_j = 0;
          }
            
            switch(ext_j)
            {
             case 1: // HTTP reply with GIF image mime type
             sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: image/gif\r\nConnection: Close\r\n\r\n"); 
             break;
             
             case 2: // HTTP reply with JPG image mime type
             sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: image/jpg\r\nConnection: Close\r\n\r\n");
             break;
             
             case 3: // HTTP reply with PNG image mime type
             sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: image/jpg\r\nConnection: Close\r\n\r\n");
             break;
             
             case 4: // HTTP reply with TIFF image mime type
             sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: image/tiff\r\nConnection: Close\r\n\r\n");
             break;
             
             default: // HTTP reply with HTML mime type
             sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");        
            }
                
            client.send(httpHeader,strlen(httpHeader));
            uart.printf(" file ");
            while((rdCnt = fread(buffer, sizeof( char ), 1024, fp)) == 1024)
            {
                client.send(buffer, rdCnt);
                uart.printf(".");
            }
            client.send(buffer, rdCnt);
            fclose(fp);
            uart.printf("done\n");
        }
    }
}

int main(void)
{
    ledTick.attach(&ledTickfunc,0.5);
    // Serial Interface eth;
    // Serial port configuration (valeurs par defaut) : 9600 baud, 8-bit data, no parity, stop bit
    uart.baud(9600);
    uart.format(8, SerialBase::None, 1);
    uart.printf("Initializing\n");
  wait(1.0);
//    Check File System
    uart.printf("Checking File System\n");
    DIR *d = opendir("/sd/");
    if(d != NULL) 
    {
        uart.printf("SD Card Present\n");
    } 
    else 
    {
        uart.printf("SD Card Root Directory Not Found\n");
    }
   wait(1.0);
//    EthernetInterface eth;
    uart.printf("Initializing Ethernet\n");
    #if USE_DHCP
    //eth.init Use DHCP
    int ret = eth.init((uint8_t*)MAC);    // Use DHCP for WIZnetInterface
    uart.printf("Connecting DHCP\n");
    #else
    int ret = eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    uart.printf("Connecting (IP,mask,Gateway)\n");
    #endif
    wait(1.0);
    // Check Ethernet Link-Done
    uart.printf("Check Ethernet Link\r\n");
    
    if(eth.link() == true) 
    { 
     uart.printf("- Ethernet PHY Link - Done\r\n");
     //led_r = LED_ON;
     COLOR(_RED_);
    }
    else 
    {
     uart.printf("- Ethernet PHY Link - Fail\r\n");
     //led_r = LED_OFF;
     COLOR(_BLACK_);
    }
    wait(1.0);
    if(!ret) 
    {
     uart.printf("Initialized, MAC: %s\r\n", eth.getMACAddress());
     ret = eth.connect();
     
     if(!ret) 
     {
            uart.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      eth.getIPAddress(), eth.getNetworkMask(), eth.getGateway());
      // led_b = LED_ON, led_g = LED_ON;
      COLOR(_CYAN_);
     } 
     else 
     {
            uart.printf("Error ethernet.connect() - ret = %d\r\n", ret);
      //led_b = LED_OFF;
      COLOR(_BLUE_);
      exit(0);
     }
    } 
    else 
    {
        uart.printf("Error ethernet.init() - ret = %d\r\n", ret);
     //led_b = LED_OFF;
     COLOR(_BLACK_);
     exit(0);
    }    
    wait(1.0);
//    TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    uart.printf("Server Listening\n");

    while(true) 
    {
        uart.printf("\nWait for new connection...\r\n");
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        uart.printf("Connection from: %s\r\n", client.get_address());
        while(true) 
        {
            //led_g = LED_ON;
            COLOR(_GREEN_);
            int n = client.receive(buffer, sizeof(buffer));
            if(n <= 0) break;
            uart.printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer);
            if(n >= 1024) 
            {
                sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
                break;
            } 
            else 
            {
                buffer[n]=0;
            }
            if(!strncmp(buffer, "GET ", 4)) 
            {
                uristr = buffer + 4;
                eou = strstr(uristr, " ");
                if(eou == NULL) 
                {
                    sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                } 
                else 
                {
                    *eou = 0;
                    get_file(uristr);
                }
            }
        }
        //led_g = LED_OFF;
        COLOR(_BLACK_);
        client.close();
    }
}
