const uint16_t   MY_PORT = 80;      // for HTTP connection
EthernetServer   myServer = EthernetServer(MY_PORT);

string       httpHeader;     // HTTP header
string       httpContent;    // HTTP content

string& page(uint8_t status); // Declaration de la fonction page

// analyse the url given
// return values: -1 invalid password
//                -2 no command given but password valid
//                -3 just refresh page
//                 0 switch off
//                 1 switch on
//
//                The string passed to this function will look like this:
//                GET /password HTTP/1.....
//                GET /password/ HTTP/1.....
//                GET /password/?sw=1 HTTP/1.....
//                GET /password/?sw=0 HTTP/1.....

int8_t analyse_get_url(string& str)
{
    if(str.substr(5, PASSWORD.size()) != PASSWORD)
        return(-1);

    uint8_t pos = 5 + PASSWORD.size();

    if(str.substr(pos, 1) == " ") return(-2);

    if(str.substr(pos, 1) != "/") return(-1);

    pos++;

    string cmd(str.substr(pos, 5));

    if(cmd == "?sw=0")  return(OFF);

    if(cmd == "?sw=1")  return(ON);

    return(-3);
}


    
string& moved_perm(uint8_t flag)
{
    if(flag == 1)
        httpContent = "/" +  PASSWORD + "/";
    else
        httpContent = "";
 
    httpContent += "<h1>301 Moved Permanently ";
    httpContent += str_moved_perm;
    httpContent += "</h1>\r\n";
    
    return (httpContent);
}

string& page_toggle_switch(uint8_t status)
{
    //-------------
    httpContent = str_DOCTYPE;
    httpContent += "<HTML><HEAD>\r\n";
    httpContent += "<title>WEB Server Nucleo F411RE - ENC28J60 - Password Page</title>\r\n";
    httpContent += "</HEAD><BODY><center>\r\n";
    httpContent += "<h2>WEB Server Nucleo F411RE - ENC28J60 - Password Page</h2>\r\n<p>";
    httpContent += str_image_Password_Folder;
    httpContent += "<p>\r\n";
    
    if(status == 1)
    {
        httpContent += "<hr><pre>\r\n  <font color=#00FF00>ON</font>";
        httpContent += " <a href=\"./?sw=0\">[switch off]</a>";
        httpContent += str_ampoule_OFF;
        httpContent += "\r\n";
    }
    else
    {
        httpContent += "<hr><pre>\r\n  <font color=#FF0000>OFF</font>";
        httpContent += " <a href=\"./?sw=1\">[switch on]</a>";
        httpContent += str_ampoule_ON;
        httpContent += "\r\n";
    }

    httpContent += "  <a href=\".\">[refresh status]</a>\r\n";
    httpContent += "</pre>\r\n<hr>\r\n";
    
    httpContent += "</center></BODY></HTML>";
    //-----------
    //wait(1);
    return httpContent;
}

void http_send(EthernetClient& client, string& header, string& content)
{
    char content_length[5] = {};

    header += "\r\nContent-Type: text/html\r\n";
    header += "Content-Length: ";
    sprintf(content_length, "%d", content.length());
    header += string(content_length) + "\r\n";
    header += "Pragma: no-cache\r\n";
    header += "Connection: About to close\r\n";
    header += "\r\n";
    string webpage = header + content;
    client.write((uint8_t*)webpage.c_str(),webpage.length());
}

void HTTP_LOOP(void)
{
//-----------------      
    UIPEthernet.begin(MY_MAC,MY_IP);
    myServer.begin();
   //----BEGIN WHILE----------- 
  while(1)
    {

     EthernetClient client = myServer.available();
        if(client)
        {
            size_t size = client.available();
            if(size > 0)
            {
                uint8_t* buf = (uint8_t*)malloc(size);
                size = client.read(buf, size);
                string received((char*)buf);
                free(buf);
                if(received.substr(0, 3) != "GET")
                {
                    // head, post or other method
                    // for possible status codes see:
                    // http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
                    httpHeader = HTTP_OK;
                    httpContent = "<h1>200 OK</h1>";
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                if(received.substr(0, 6) == "GET / ")
                {
                    httpHeader = HTTP_OK;
                    // httpContent = "<p>Usage: http://host_or_ip/password</p>\r\n";
                    // http_send(client, httpHeader, httpContent);
                    
                    http_send(client, httpHeader, page(sw));
                    continue;
                }

                int cmd = analyse_get_url(received);

                if(cmd == -2)
                {
                    // redirect to the right base url
                    httpHeader = MOVED_PERM;
                    http_send(client, httpHeader, moved_perm(1));
                    continue;
                }

                if(cmd == -1)
                {
                    httpHeader = UNAUTHORIZED;
                    httpContent = "<h1>401 Unauthorized ";
                    httpContent = str_Unauthorized;
                    httpContent += "</h1>\r\n";
                    
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                if(cmd == 1)
                { 
                 sw = 1;     // switch on
                }

                if(cmd == 0)
                {
                 sw = 0;    // switch off
                }

                httpHeader = HTTP_OK;
                http_send(client, httpHeader, page_toggle_switch(sw));
            }
        }  

    }
    //----END WHILE-----------    
}