#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "math.h"

I2C i2c(I2C_SDA,I2C_SCL);
LCD_DISCO_F746NG lcd;
TS_DISCO_F746NG ts;

int main()
{

    TS_StateTypeDef TS_State;
    uint16_t x, y;
    char address ;
    uint8_t status;

    char text[50];
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    uint32_t couleur;

    char control[3];
    char dataProx[2];

    char dataR1[1];
    char dataR2[1];

    char dataG1[1];
    char dataG2[1];

    char dataB1[1];
    char dataB2[1];

    int rayon;

    int r,g,b,f;

    address=0x72; //adresse du capteur sur 7 bits (0x39 sur 8 bits)

    dataProx[0]=0x00;

    status = ts.Init(lcd.GetXSize()+10, lcd.GetYSize()+10);
    lcd.Clear(0xFFFFFFF0);
    lcd.SetFont(&Font12);
    lcd.SetBackColor(0xFFFFFFFE);
    lcd.SetTextColor(LCD_COLOR_BLACK);

    control[0]=0x80;  //registre activation power / proximité / RGB
    control[1]=0x07;  //commande d'activation proximité et RGB
    i2c.write(address, control, 2);

    control[0]=0x8F;  //registre led
    control[1]=0x07;  //commande du gain
    i2c.write(address, control, 2);

    while(1) {

        control[0]=0x9C;  //registre donnée proximité
        i2c.write(address, control, 1,true);
        i2c.read(address,dataProx,1);

        control[0]= 0x96; //registre donnée rouge partie 1
        i2c.write(address, control, 1,true);
        i2c.read(address,dataR1,1);

        control[0]= 0x97; //registre donnée rouge partie 2
        i2c.write(address, control, 1,true);
        i2c.read(address,dataR2,1);

        control[0]= 0x98; //registre donnée vert partie 1
        i2c.write(address, control, 1,true);
        i2c.read(address,dataG1,1);

        control[0]= 0x99; //registre donnée vert partie 2
        i2c.write(address, control, 1,true);
        i2c.read(address,dataG2,1);

        control[0]= 0x9A; //registre donnée bleu partie 1
        i2c.write(address, control, 1,true);
        i2c.read(address,dataB1,1);

        control[0]= 0x9B; //registre donnée bleu partie 2
        i2c.write(address, control, 1,true);
        i2c.read(address,dataB2,1);

        r=/*dataR2[0] << 4 |*/ dataR1[0]*1.6;  //composition de la valeur rouge
        g=/*dataG2[0] << 4 |*/ dataG1[0]*1.6;  //composition de la valeur vert
        b=/*dataB2[0] << 4 |*/ dataB1[0]*1.6;  //composition de la valeur bleu
        if (r>255) r=255;
        if (g>255) g=255;
        if (b>255) b=255;
        f=0xFF;

        couleur = f << 24 | r << 16 | g << 8 | b; //combinaison des valeurs des couleur au format uint32_t rgb

        lcd.SetTextColor(couleur);
        sprintf((char*)text, "couleur %0X  P : %0X",couleur,dataProx[0]); // stockage du texte contenant toute les données
        lcd.DisplayStringAt(0, LINE(0), (uint8_t *)&text, LEFT_MODE); //écriture de la valeur rgb de la couleur détectée

        ts.GetState(&TS_State);
        if (TS_State.touchDetected) {
            // Clear lines corresponding to old touches coordinates
            if (TS_State.touchDetected < prev_nb_touches) {
                for (idx = (TS_State.touchDetected + 1); idx <= 2; idx++) {
                    lcd.ClearStringLine(idx);
                }
            }
            prev_nb_touches = TS_State.touchDetected;
            cleared = 0;

            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx]; //récupération de la position x de l'appui
                y = TS_State.touchY[idx]; //récupération de la position y de l'appui
            }


            rayon = ceil((float)dataProx[0]/255.0 * 15.0 +1.0);
            if((TS_State.touchY[0]-rayon>1)&&(TS_State.touchX[0]-rayon>1)) {
                lcd.FillCircle(TS_State.touchX[0], TS_State.touchY[0], rayon);
            }
        } else {
            if (!cleared) {
                //lcd.Clear(0xFFFFFFF0);
                cleared = 1;
            }
        }
    }


}


