#include "mbed.h"
#include "BtnEventM0.h"

BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

BusOut stLED(P1_13,P1_12);

BtnEventM0 sw4(P1_16), sw3(P0_23);

class FahrradLeuchte
{
    public:
        void Init()
        {
            state = 1; t1.start();   
        }
    public:
        void State1Func();
        void State2Func();
        void State3Func();
    public:  
        void State1Action(); // Bit0 ( LED ) mit 10 Hz blinken
        void State2Action(); // Bit2 ( LED ) mit 5 Hz blinken
        void State3Action(); // Bit4 ( LED ) mit 2 Hz blinken
    public:
        // State sagt uns in welchem Zustand sich die FahrradLeuchte gerade befindet
        int state;
        Timer t1;
};

// Eine FahrradLeuchte anlegen
FahrradLeuchte fl;

int main(void)
{
    sw3.Init(); sw4.Init();
    fl.Init();
    lb = 0;
    while(1)
    {
        if (fl.state == 1)
            fl.State1Func();
        if (fl.state == 2)
            fl.State2Func();
        if (fl.state == 3)
            fl.State3Func();
    }
}

void FahrradLeuchte::State1Func()
{
    // einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 1;  // Anzeigen, dass im Zustand 1 sind
    t1.reset();
    while(1)
    {
        // Btn's abfragen und möglicherweise Zustand ändern
        State1Action();
        if (sw4.CheckFlag())
        {
            state = 2; return;
        }
        if (sw3.CheckFlag())
        {
            state = 3; return;
        }
    }
}


void FahrradLeuchte::State1Action()
{
   if (t1.read_ms() > 100)
   {
    t1.reset();
    if (lb == 0)
        lb = 1; // Mit Bit0 blinken
    else
        lb = 0;
    }
}

void FahrradLeuchte::State2Func()
{
    
    // einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 2;  // Anzeigen, dass im Zustand 1 sind
    t1.reset();
    while(1)
    {
        // Btn's abfragen und möglicherweise Zustand ändern
        State2Action();
        if (sw4.CheckFlag())
        {
            state = 3; return;
        }
        if (sw3.CheckFlag())
        {
            state = 1; return;
        }
    }
    
}

void FahrradLeuchte::State2Action()
{
   if (t1.read_ms() > 50)
   {
    t1.reset();
    if (lb == 0)
        lb = 2; // Mit Bit0 blinken
    else
        lb = 0;
    }
}

void FahrradLeuchte::State3Func()
{
    // einmalige Aktion beim Eintritt in die Zustandsfunktion
    stLED = 3;  // Anzeigen, dass im Zustand 1 sind
    t1.reset();
    while(1)
    {
        // Btn's abfragen und möglicherweise Zustand ändern
        State3Action();
        if (sw4.CheckFlag())
        {
            state = 1; return;
        }
        if (sw3.CheckFlag())
        {
            state = 2; return;
        }
    }
}

void FahrradLeuchte::State3Action()
{
   if (t1.read_ms() > 20)
   {
    t1.reset();
    if (lb == 0)
        lb = 4; // Mit Bit0 blinken
    else
        lb = 0;
    }
}