#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void bewegen()
{
     bertl.Move();    
}

void links()
{
    bertl.TurnLeft();    
}

void LedKette(int value)
{
    bertl.NibbleLeds(value);
}


void LedsOn(int16_t led)
{
    bertl.TurnLedOn(led);    
}

void LedsOff(int16_t led)
{
    bertl.TurnLedOff(led);    
}

void RGBLed(bool red, bool green, bool blue)
{
    bertl.RGBLed(red,  green, blue);    
}

void BlueLedsOn()
{
    bertl.BlueLedsON();
}


void BlueLedsOff()
{
    BlueLedsOff();
}

bool Frei()
{
    if (bertl.FrontIsClear())
        return true;
        
    else
        return false ;   
}





bool gedrueckt()
{
    if (bertl.WaitUntilButtonPressed())
        return true;
    else
        return false;
}

bool streifen()
{
    if(bertl.NextToABeeper())
        return true;
    else    
        return false;    
}

bool pressed(const int btn)
{
    if(bertl.IsButtonPressed(btn))
        return true;
    else
        return false;
}


int main() 
{
       
}
